/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CombineFileRecordReaderWrapper<K, V>
implements RecordReader<K, V> {
    private final RecordReader<K, V> delegate;

    protected CombineFileRecordReaderWrapper(FileInputFormat<K, V> inputFormat, CombineFileSplit split, Configuration conf, Reporter reporter, Integer idx) throws IOException {
        FileSplit fileSplit = new FileSplit(split.getPath(idx), split.getOffset(idx), split.getLength(idx), split.getLocations());
        this.delegate = inputFormat.getRecordReader(fileSplit, (JobConf)conf, reporter);
    }

    @Override
    public boolean next(K key, V value) throws IOException {
        return this.delegate.next(key, value);
    }

    @Override
    public K createKey() {
        return this.delegate.createKey();
    }

    @Override
    public V createValue() {
        return this.delegate.createValue();
    }

    @Override
    public long getPos() throws IOException {
        return this.delegate.getPos();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public float getProgress() throws IOException {
        return this.delegate.getProgress();
    }
}

