/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.google.common.base.Throwables;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.HashSet;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.ServiceFailureException;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.PersistedPolarisPrincipal;
import org.apache.polaris.service.auth.PolarisCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Identifier(value="default")
public class DefaultAuthenticator
implements Authenticator {
    public static final String PRINCIPAL_ROLE_ALL = "PRINCIPAL_ROLE:ALL";
    public static final String PRINCIPAL_ROLE_PREFIX = "PRINCIPAL_ROLE:";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticator.class);
    @Inject
    MetaStoreManagerFactory metaStoreManagerFactory;
    @Inject
    CallContext callContext;

    @Override
    public PolarisPrincipal authenticate(PolarisCredential credentials) {
        LOGGER.debug("Resolving principal for credentials={}", (Object)credentials);
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(this.callContext.getRealmContext());
        PolarisEntity principal = null;
        try {
            if (credentials.getPrincipalId() != null && credentials.getPrincipalId() > 0L) {
                principal = PolarisEntity.of((EntityResult)metaStoreManager.loadEntity(this.callContext.getPolarisCallContext(), 0L, credentials.getPrincipalId().longValue(), PolarisEntityType.PRINCIPAL));
            } else if (credentials.getPrincipalName() != null) {
                principal = metaStoreManager.findPrincipalByName(this.callContext.getPolarisCallContext(), credentials.getPrincipalName()).orElse(null);
            }
        }
        catch (Exception e) {
            LOGGER.atError().addKeyValue("errMsg", (Object)e.getMessage()).addKeyValue("stackTrace", (Object)Throwables.getStackTraceAsString((Throwable)e)).log("Unable to authenticate user with token");
            throw new ServiceFailureException("Unable to fetch principal entity", new Object[0]);
        }
        if (principal == null || principal.getType() != PolarisEntityType.PRINCIPAL) {
            LOGGER.warn("Failed to resolve principal from credentials={}", (Object)credentials);
            throw new NotAuthorizedException("Unable to authenticate", new Object[0]);
        }
        LOGGER.debug("Resolved principal: {}", (Object)principal);
        boolean allRoles = credentials.getPrincipalRoles().contains(PRINCIPAL_ROLE_ALL);
        HashSet<String> activatedPrincipalRoles = new HashSet<String>();
        if (!allRoles) {
            activatedPrincipalRoles.addAll(credentials.getPrincipalRoles().stream().filter(s -> s.startsWith(PRINCIPAL_ROLE_PREFIX)).map(s -> s.substring(PRINCIPAL_ROLE_PREFIX.length())).toList());
        }
        LOGGER.debug("Resolved principal: {}", (Object)principal);
        return PersistedPolarisPrincipal.of(new PrincipalEntity((PolarisBaseEntity)principal), activatedPrincipalRoles);
    }
}

