/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.client.common;

import java.io.ByteArrayOutputStream;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import org.apache.livy.annotations.Private;
import org.apache.livy.shaded.kryo.kryo.Kryo;
import org.apache.livy.shaded.kryo.kryo.io.Input;
import org.apache.livy.shaded.kryo.kryo.io.Output;
import org.apache.livy.shaded.kryo.kryo.serializers.ClosureSerializer;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

@Private
public class Serializer {
    private static final int REG_ID_BASE = 16;
    private final ThreadLocal<Kryo> kryos;

    public Serializer(final Class<?> ... klasses) {
        this.kryos = new ThreadLocal<Kryo>(){

            @Override
            protected Kryo initialValue() {
                Kryo kryo = new Kryo();
                int count = 0;
                for (Class klass : klasses) {
                    kryo.register(klass, 16 + count);
                    ++count;
                }
                kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
                kryo.register(SerializedLambda.class);
                kryo.register(ClosureSerializer.Closure.class, new ClosureSerializer());
                kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
                return kryo;
            }
        };
    }

    public Object deserialize(ByteBuffer data) {
        byte[] b = new byte[data.remaining()];
        data.get(b);
        Input kryoIn = new Input(b);
        return this.kryos.get().readClassAndObject(kryoIn);
    }

    public ByteBuffer serialize(Object data) {
        ByteBufferOutputStream out = new ByteBufferOutputStream();
        Output kryoOut = new Output(out);
        this.kryos.get().writeClassAndObject(kryoOut, data);
        kryoOut.flush();
        return out.getBuffer();
    }

    private static class ByteBufferOutputStream
    extends ByteArrayOutputStream {
        private ByteBufferOutputStream() {
        }

        public ByteBuffer getBuffer() {
            ByteBuffer result = ByteBuffer.wrap(this.buf, 0, this.count);
            this.buf = null;
            this.reset();
            return result;
        }
    }
}

