/*
 * Decompiled with CFR 0.152.
 */
package org.scalatra.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.scalatra.util.UrlCodingUtils;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public abstract class UrlCodingUtils$class {
    public static boolean isUrlEncoded(UrlCodingUtils $this, String string) {
        return $this.org$scalatra$util$UrlCodingUtils$$PctEncoded().findFirstIn((CharSequence)string).isDefined();
    }

    public static boolean containsInvalidUriChars(UrlCodingUtils $this, String string) {
        return $this.org$scalatra$util$UrlCodingUtils$$InvalidChars().findFirstIn((CharSequence)string).isDefined();
    }

    public static boolean needsUrlEncoding(UrlCodingUtils $this, String string) {
        return !$this.isUrlEncoded(string) && $this.containsInvalidUriChars(string);
    }

    public static String ensureUrlEncoding(UrlCodingUtils $this, String string) {
        String string2;
        if ($this.needsUrlEncoding(string)) {
            String x$4 = string;
            BitSet x$5 = $this.org$scalatra$util$UrlCodingUtils$$toSkip();
            Charset x$6 = $this.urlEncode$default$2();
            boolean x$7 = $this.urlEncode$default$3();
            string2 = $this.urlEncode(x$4, x$6, x$7, x$5);
        } else {
            string2 = string;
        }
        return string2;
    }

    public static String ensureUppercasedEncodings(UrlCodingUtils $this, String string) {
        return $this.org$scalatra$util$UrlCodingUtils$$LowerPctEncoded().replaceAllIn((CharSequence)string, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Regex.Match x$3) {
                Regex.Match match = x$3;
                Option option = Regex.Groups$.MODULE$.unapplySeq(match);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                    String v = (String)((SeqLike)option.get()).apply(0);
                    String string = new StringBuilder().append((Object)"%").append((Object)v.toUpperCase(Locale.ENGLISH)).toString();
                    return string;
                }
                throw new MatchError((Object)match);
            }
        });
    }

    public static String pathPartEncode(UrlCodingUtils $this, String toEncode, Charset charset, boolean spaceIsPlus) {
        return $this.urlEncode(toEncode, charset, spaceIsPlus, $this.org$scalatra$util$UrlCodingUtils$$toSkipEncoding());
    }

    public static Charset pathPartEncode$default$2(UrlCodingUtils $this) {
        return $this.org$scalatra$util$UrlCodingUtils$$Utf8();
    }

    public static boolean pathPartEncode$default$3(UrlCodingUtils $this) {
        return false;
    }

    public static String queryPartEncode(UrlCodingUtils $this, String toEncode, Charset charset, boolean spaceIsPlus) {
        return $this.urlEncode(toEncode, charset, spaceIsPlus, (BitSet)$this.org$scalatra$util$UrlCodingUtils$$toSkipEncoding().$plus$plus((GenTraversableOnce)BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{47, 63}))));
    }

    public static Charset queryPartEncode$default$2(UrlCodingUtils $this) {
        return $this.org$scalatra$util$UrlCodingUtils$$Utf8();
    }

    public static boolean queryPartEncode$default$3(UrlCodingUtils $this) {
        return false;
    }

    public static String urlEncode(UrlCodingUtils $this, String toEncode, Charset charset, boolean spaceIsPlus, BitSet toSkip) {
        ByteBuffer in = charset.encode($this.ensureUppercasedEncodings(toEncode));
        CharBuffer out = CharBuffer.allocate((int)RichFloat$.MODULE$.ceil$extension(Predef$.MODULE$.floatWrapper((float)(in.remaining() * 3))));
        while (in.hasRemaining()) {
            CharBuffer charBuffer;
            int b = in.get() & 0xFF;
            if (toSkip.contains(b)) {
                charBuffer = out.put((char)b);
                continue;
            }
            if (b == $this.org$scalatra$util$UrlCodingUtils$$space() && spaceIsPlus) {
                charBuffer = out.put('+');
                continue;
            }
            out.put('%');
            out.put(BoxesRunTime.unboxToChar((Object)$this.org$scalatra$util$UrlCodingUtils$$HexUpperCaseChars().apply(b >> 4 & 0xF)));
            charBuffer = out.put(BoxesRunTime.unboxToChar((Object)$this.org$scalatra$util$UrlCodingUtils$$HexUpperCaseChars().apply(b & 0xF)));
        }
        out.flip();
        return out.toString();
    }

    public static Charset urlEncode$default$2(UrlCodingUtils $this) {
        return $this.org$scalatra$util$UrlCodingUtils$$Utf8();
    }

    public static boolean urlEncode$default$3(UrlCodingUtils $this) {
        return false;
    }

    public static BitSet urlEncode$default$4(UrlCodingUtils $this) {
        return $this.org$scalatra$util$UrlCodingUtils$$toSkip();
    }

    public static String urlDecode(UrlCodingUtils $this, String toDecode, Charset charset, boolean plusIsSpace, String toSkip) {
        CharBuffer in = CharBuffer.wrap(toDecode);
        ByteBuffer out = ByteBuffer.allocate(in.remaining() * 3);
        BitSet skip = (BitSet)BitSet$.MODULE$.apply(((SetLike)new StringOps(Predef$.MODULE$.augmentString(toSkip)).toSet().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(char c) {
                return c;
            }
        }, Set$.MODULE$.canBuildFrom())).toSeq());
        while (in.hasRemaining()) {
            Buffer buffer;
            int mark = in.position();
            char c = in.get();
            if (c == '%') {
                if (in.remaining() >= 2) {
                    char xc = in.get();
                    char yc = in.get();
                    int x = Character.digit(xc, 16);
                    int y = Character.digit(yc, 16);
                    if (x != -1 && y != -1) {
                        int oo = (x << 4) + y;
                        if (skip.contains(oo)) {
                            out.put((byte)37);
                            out.put((byte)xc);
                            buffer = out.put((byte)yc);
                            continue;
                        }
                        buffer = out.put((byte)oo);
                        continue;
                    }
                    out.put((byte)37);
                    buffer = in.position(mark + 1);
                    continue;
                }
                buffer = out.put((byte)37);
                continue;
            }
            buffer = c == '+' && plusIsSpace ? out.put((byte)32) : ($this.org$scalatra$util$UrlCodingUtils$$toSkip().contains((int)c) ? out.put((byte)c) : out.put(charset.encode(String.valueOf(c))));
        }
        out.flip();
        return charset.decode(out).toString();
    }

    public static Charset urlDecode$default$2(UrlCodingUtils $this) {
        return $this.org$scalatra$util$UrlCodingUtils$$Utf8();
    }

    public static boolean urlDecode$default$3(UrlCodingUtils $this) {
        return false;
    }

    public static String urlDecode$default$4(UrlCodingUtils $this) {
        return "";
    }

    public static void $init$(UrlCodingUtils $this) {
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$toSkip_$eq((BitSet)BitSet$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)((TraversableLike)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString("!$&'()*+,;=:/?@-._~")).toSet(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(char x$1) {
                return x$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$toSkipEncoding_$eq((BitSet)BitSet$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)((TraversableLike)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString(":@-._~")).toSet(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(char x$2) {
                return x$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$space_$eq(32);
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$PctEncoded_$eq(new StringOps(Predef$.MODULE$.augmentString("%([0-9a-fA-F][0-9a-fA-F])")).r());
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$LowerPctEncoded_$eq(new StringOps(Predef$.MODULE$.augmentString("%([0-9a-f][0-9a-f])")).r());
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$InvalidChars_$eq(new StringOps(Predef$.MODULE$.augmentString("[^\\.a-zA-Z0-9!$&'()*+,;=:/?#\\[\\]@-_~]")).r());
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$HexUpperCaseChars_$eq((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 16).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final char apply(int i) {
                return Character.toUpperCase(Character.forDigit(i, 16));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$UTF_8_$eq("UTF-8");
        $this.org$scalatra$util$UrlCodingUtils$_setter_$org$scalatra$util$UrlCodingUtils$$Utf8_$eq(Charset.forName($this.org$scalatra$util$UrlCodingUtils$$UTF_8()));
    }
}

