/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */

package org.dashbuilder.renderer.c3.client.jsbinding;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL, name = "Object")
public class C3Padding {
    
    @JsOverlay
    static C3Padding create(int top, int right, int bottom, int left ) {
        C3Padding instance = new C3Padding();
        instance.setTop(top);
        instance.setRight(right);
        instance.setBottom(bottom);
        instance.setLeft(left);
        return instance;
    }
    
    @JsProperty
    public native void setTop(int top);
    
    @JsProperty
    public native void setRight(int right);
    
    @JsProperty
    public native void setBottom(int bottom);
    
    @JsProperty
    public native void setLeft(int left);
    
}