import { JSONSchemaBridge } from "uniforms-bridge-json-schema";
export class FormJsonSchemaBridge extends JSONSchemaBridge {
    constructor(formSchema, validator, i18n) {
        super(formSchema, validator);
        this.formSchema = formSchema;
        this.validator = validator;
        this.i18n = i18n;
    }
    getProps(name, props) {
        var _a;
        const finalProps = super.getProps(name, props);
        if (finalProps.label) {
            finalProps.label = (_a = name.split(".").pop()) !== null && _a !== void 0 ? _a : name;
        }
        return finalProps;
    }
    getField(name) {
        const field = super.getField(name);
        if (!field.type) {
            field.type = "string";
        }
        if (field.enum) {
            field.placeholder = this.i18n.schema.selectPlaceholder;
        }
        return field;
    }
}
//# sourceMappingURL=FormJsonSchemaBridge.js.map