import * as React from "react";
import { isEmpty } from "lodash";
import Moment from "react-moment";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { TaskState } from "./TaskState";
export const TaskDetails = ({ userTask, ouiaId, ouiaSafe }) => {
    if (!userTask) {
        return (React.createElement(KogitoSpinner, Object.assign({}, componentOuiaProps(ouiaId, "task-details-component-loading", ouiaSafe), { spinnerText: "Loading task details" })));
    }
    const resolveTaskPriority = (priority) => {
        switch (priority) {
            case "0":
                return "0 - High";
            case "5":
                return "5 - Medium";
            case "10":
                return "10 - Low";
        }
        return priority || "-";
    };
    return (React.createElement(Form, Object.assign({}, componentOuiaProps(ouiaId, "task-details-component", ouiaSafe)),
        React.createElement(FormGroup, { label: "Name", fieldId: "name" },
            React.createElement(Text, { component: TextVariants.p }, userTask.referenceName)),
        userTask.description && (React.createElement(FormGroup, { label: "Description", fieldId: "description" },
            React.createElement(Text, { component: TextVariants.p }, userTask.description))),
        React.createElement(FormGroup, { label: "ID", fieldId: "id" },
            React.createElement(Text, { component: TextVariants.p }, userTask.id)),
        React.createElement(FormGroup, { label: "State", fieldId: "state" },
            React.createElement(TaskState, { task: userTask })),
        React.createElement(FormGroup, { label: "Priority", fieldId: "priority" },
            React.createElement(Text, { component: TextVariants.p }, resolveTaskPriority(userTask.priority))),
        React.createElement(FormGroup, { label: "Owner", fieldId: "owner" },
            React.createElement(Text, { component: TextVariants.p }, userTask.actualOwner || "-")),
        !isEmpty(userTask.potentialUsers) && (React.createElement(FormGroup, { label: "Potential users", fieldId: "potential_users" },
            React.createElement(Text, { component: TextVariants.p }, userTask.potentialUsers.join(", ")))),
        !isEmpty(userTask.potentialGroups) && (React.createElement(FormGroup, { label: "Potential groups", fieldId: "potential_groups" },
            React.createElement(Text, { component: TextVariants.p }, userTask.potentialGroups.join(", ")))),
        React.createElement(FormGroup, { label: "Started", fieldId: "started" }, userTask.started ? (React.createElement(Text, { component: TextVariants.p },
            React.createElement(Moment, { fromNow: true }, new Date(`${userTask.started}`)))) : ("-")),
        userTask.completed ? (React.createElement(FormGroup, { label: "Completed", fieldId: "completed" },
            React.createElement(Text, { component: TextVariants.p },
                React.createElement(Moment, { fromNow: true }, new Date(`${userTask.completed}`))))) : (React.createElement(FormGroup, { label: "Last Update", fieldId: "lastUpdate" },
            React.createElement(Text, { component: TextVariants.p },
                React.createElement(Moment, { fromNow: true }, new Date(`${userTask.lastUpdate}`))))),
        React.createElement(FormGroup, { label: "Process", fieldId: "process" },
            React.createElement(Text, { component: TextVariants.p }, userTask.processId)),
        React.createElement(FormGroup, { label: "Process Instance ID", fieldId: "processInstance" },
            React.createElement(Text, { component: TextVariants.p }, userTask.processInstanceId))));
};
export default TaskDetails;
//# sourceMappingURL=TaskDetails.js.map