import React from "react";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const DisablePopup = ({ processInstanceData, component, ouiaId, ouiaSafe, }) => {
    var _a, _b, _c;
    let content = "";
    if (!((_a = processInstanceData.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) && processInstanceData.serviceUrl === null) {
        content =
            "Management add-on capability not enabled & missing the kogito.service.url property. Contact your administrator to set up.";
    }
    else if (processInstanceData.serviceUrl === null && ((_b = processInstanceData.addons) === null || _b === void 0 ? void 0 : _b.includes("process-management"))) {
        content = "This Kogito runtime is missing the kogito.service.url property. Contact your administrator to set up.";
    }
    else if (!((_c = processInstanceData.addons) === null || _c === void 0 ? void 0 : _c.includes("process-management")) && processInstanceData.serviceUrl !== null) {
        content = "Management add-on capability not enabled. Contact your administrator to set up";
    }
    return (React.createElement(Tooltip, Object.assign({ content: content, id: "disable-popup-tooltip" }, componentOuiaProps(ouiaId, "disable-popup", ouiaSafe)), component));
};
export default DisablePopup;
//# sourceMappingURL=DisablePopup.js.map