"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModelReducer = void 0;
var Actions_1 = require("./Actions");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var ScorecardReducer_1 = require("./ScorecardReducer");
var DelegatingModelReducer_1 = require("./DelegatingModelReducer");
var combine_reducer_1 = require("combine-reducer");
var CharacteristicsReducer_1 = require("./CharacteristicsReducer");
var CharacteristicReducer_1 = require("./CharacteristicReducer");
var OutputFieldReducer_1 = require("./OutputFieldReducer");
var OutputReducer_1 = require("./OutputReducer");
var MiningSchemaReducer_1 = require("./MiningSchemaReducer");
var MiningSchemaFieldReducer_1 = require("./MiningSchemaFieldReducer");
var paths_1 = require("../paths");
var ModelReducer = function (historyService, validationRegistry) {
    var scorecardReducer = (0, combine_reducer_1.default)((0, ScorecardReducer_1.ScorecardReducer)(historyService, validationRegistry), {
        MiningSchema: (0, combine_reducer_1.default)((0, MiningSchemaReducer_1.MiningSchemaReducer)(historyService, validationRegistry), {
            MiningField: (0, MiningSchemaFieldReducer_1.MiningSchemaFieldReducer)(historyService, validationRegistry),
        }),
        Output: (0, combine_reducer_1.default)((0, OutputReducer_1.OutputReducer)(historyService, validationRegistry), {
            OutputField: (0, OutputFieldReducer_1.OutputFieldReducer)(historyService, validationRegistry),
        }),
        Characteristics: (0, combine_reducer_1.default)((0, CharacteristicsReducer_1.CharacteristicsReducer)(historyService), {
            Characteristic: (0, CharacteristicReducer_1.CharacteristicReducer)(historyService),
        }),
    });
    var delegate = (0, DelegatingModelReducer_1.DelegatingModelReducer)(historyService, new Map([
        [
            "Scorecard",
            {
                reducer: scorecardReducer,
                factory: function (data) {
                    var model = new pmml_editor_marshaller_1.Scorecard(data);
                    model._type = "Scorecard";
                    return model;
                },
            },
        ],
    ]));
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.DeleteModel:
                historyService.batch(state, (0, paths_1.Builder)().forModel().build(), function (draft) {
                    if (draft !== undefined) {
                        var modelIndex = action.payload.modelIndex;
                        if (modelIndex >= 0 && modelIndex < draft.length) {
                            draft.splice(modelIndex, 1);
                        }
                    }
                });
                return state;
        }
        return delegate(state, action);
    };
};
exports.ModelReducer = ModelReducer;
//# sourceMappingURL=ModelReducer.js.map