"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var arrow_alt_circle_right_icon_1 = require("@patternfly/react-icons/dist/js/icons/arrow-alt-circle-right-icon");
require("./MiningSchemaFieldLabels.scss");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_1 = require("../../EditorCore/atoms");
var MiningSchema_1 = require("../../../validation/MiningSchema");
var MiningSchemaFieldLabels = function (props) {
    var index = props.index, modelIndex = props.modelIndex, field = props.field, onEdit = props.onEdit, onDelete = props.onDelete, editing = props.editing;
    var BasicMiningLabel = function (name, value, onClose) {
        return ((0, jsx_runtime_1.jsxs)(Label_1.Label, __assign({ color: "cyan", className: "mining-schema-list__item__label", closeBtnProps: { className: "ignore-onclickoutside" }, onClose: editing ? onClose : undefined, "data-ouia-component-id": name, "data-ouia-component-type": "mining-label" }, { children: [(0, jsx_runtime_1.jsxs)("strong", { children: [name, ":"] }), "\u00A0", (0, jsx_runtime_1.jsx)("span", { children: value })] })));
    };
    var InvalidMiningLabel = function (name, value, onClose, validations) {
        return ((0, jsx_runtime_1.jsxs)(atoms_1.ValidationIndicatorLabel, __assign({ validations: validations, cssClass: "mining-schema-list__item__label", onClose: editing ? onClose : undefined }, { children: [(0, jsx_runtime_1.jsxs)("strong", { children: [name, ":"] }), "\u00A0", (0, jsx_runtime_1.jsx)("span", { children: value })] })));
    };
    var MissingValueAwareMiningLabel = function (name, value, isValueRequired, validations, onClose) {
        return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [isValueRequired && value !== undefined && BasicMiningLabel(name, value, onClose), isValueRequired && value === undefined && InvalidMiningLabel(name, (0, jsx_runtime_1.jsx)("em", { children: "Missing" }), undefined, validations), !isValueRequired && value !== undefined && InvalidMiningLabel(name, value, onClose, validations)] }));
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validationsImportance = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(index).forImportance().build());
    }, [modelIndex, index, field]);
    var validationsLowValue = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(index).forLowValue().build());
    }, [modelIndex, index, field]);
    var validationsHighValue = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(index).forHighValue().build());
    }, [modelIndex, index, field]);
    var _areLowHighValuesRequired = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.areLowHighValuesRequired)(field.outliers); }, [modelIndex, index, field]);
    var validationsMissingValueReplacement = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(index).forMissingValueReplacement().build());
    }, [modelIndex, index, field]);
    var _isMissingValueReplacementRequired = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.isMissingValueReplacementRequired)(field.missingValueTreatment); }, [modelIndex, index, field]);
    var validationsInvalidValueReplacement = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(index).forInvalidValueReplacement().build());
    }, [modelIndex, index, field]);
    var _isInvalidValueReplacementRequired = (0, react_1.useMemo)(function () { return (0, MiningSchema_1.isInvalidValueReplacementRequired)(field.invalidValueTreatment); }, [modelIndex, index, field]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [field.usageType !== undefined &&
                BasicMiningLabel("Usage Type", field.usageType, function () {
                    return onDelete(__assign(__assign({}, field), { usageType: undefined }));
                }), field.optype !== undefined &&
                BasicMiningLabel("Op Type", field.optype, function () {
                    return onDelete(__assign(__assign({}, field), { optype: undefined }));
                }), field.importance !== undefined && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validationsImportance.length === 0 &&
                        BasicMiningLabel("Importance", field.importance, function () {
                            return onDelete(__assign(__assign({}, field), { importance: undefined }));
                        }), validationsImportance.length > 0 &&
                        InvalidMiningLabel("Importance", field.importance, function () { return onDelete(__assign(__assign({}, field), { importance: undefined })); }, validationsImportance)] })), field.outliers !== undefined &&
                BasicMiningLabel("Outliers", field.outliers, function () {
                    return onDelete(__assign(__assign({}, field), { outliers: undefined }));
                }), MissingValueAwareMiningLabel("Low Value", field.lowValue, _areLowHighValuesRequired, validationsLowValue, function () {
                return onDelete(__assign(__assign({}, field), { lowValue: undefined }));
            }), MissingValueAwareMiningLabel("High Value", field.highValue, _areLowHighValuesRequired, validationsHighValue, function () {
                return onDelete(__assign(__assign({}, field), { highValue: undefined }));
            }), field.missingValueTreatment !== undefined &&
                BasicMiningLabel("Missing Value Treatment", field.missingValueTreatment, function () {
                    return onDelete(__assign(__assign({}, field), { missingValueTreatment: undefined }));
                }), MissingValueAwareMiningLabel("Missing Value Replacement", field.missingValueReplacement, _isMissingValueReplacementRequired, validationsMissingValueReplacement, function () {
                return onDelete(__assign(__assign({}, field), { missingValueReplacement: undefined }));
            }), field.invalidValueTreatment !== undefined &&
                BasicMiningLabel("Invalid Value Treatment", field.invalidValueTreatment, function () {
                    return onDelete(__assign(__assign({}, field), { invalidValueTreatment: undefined }));
                }), MissingValueAwareMiningLabel("Invalid Value Replacement", field.invalidValueReplacement, _isInvalidValueReplacementRequired, validationsInvalidValueReplacement, function () {
                return onDelete(__assign(__assign({}, field), { invalidValueReplacement: undefined }));
            }), editing && ((0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ className: "mining-schema-list__item__label", variant: "outline", color: "cyan", href: "#", icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_right_icon_1.ArrowAltCircleRightIcon, {}), onClick: function (event) {
                    event.preventDefault();
                    onEdit();
                }, "data-ouia-component-id": "edit-properties", "data-ouia-component-type": "mf-label" }, { children: "Edit Properties" })))] }));
};
exports.default = MiningSchemaFieldLabels;
//# sourceMappingURL=MiningSchemaFieldLabels.js.map