"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinearRegressionViewerPage = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var molecules_1 = require("../../EditorCore/molecules");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var __1 = require("../../..");
var react_redux_1 = require("react-redux");
require("./LinearRegressionViewerPage.scss");
var organisms_1 = require("../../EditorCore/organisms");
var molecules_2 = require("../molecules");
var LinearRegressionViewerPage = function (props) {
    var modelIndex = props.modelIndex;
    var model = (0, react_redux_1.useSelector)(function (state) {
        var _model = state.models ? state.models[modelIndex] : undefined;
        if (_model && _model instanceof pmml_editor_marshaller_1.RegressionModel) {
            var _regressionModel = _model;
            if (_regressionModel.functionName === "regression" && _regressionModel.algorithmName === "linearRegression") {
                return _regressionModel;
            }
        }
        return undefined;
    });
    return ((0, jsx_runtime_1.jsxs)("div", __assign({ "data-testid": "editor-page", className: "editor" }, { children: [!model && (0, jsx_runtime_1.jsx)(organisms_1.EmptyStateModelNotFound, {}), model && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ variant: Page_1.PageSectionVariants.light, isFilled: false }, { children: (0, jsx_runtime_1.jsx)(molecules_1.EditorHeader, { modelName: (0, __1.getModelName)(model), modelIndex: modelIndex }) })), (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ isFilled: true, style: { paddingTop: "0px" } }, { children: (0, jsx_runtime_1.jsx)(molecules_2.LinearRegressionViewAdaptor, { model: model }) }))] }))] })));
};
exports.LinearRegressionViewerPage = LinearRegressionViewerPage;
//# sourceMappingURL=LinearRegressionViewerPage.js.map