"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinearRegressionViewAdaptor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var LinearRegressionView_1 = require("./LinearRegressionView");
var react_redux_1 = require("react-redux");
var LinearRegressionViewAdaptor = function (props) {
    var model = props.model;
    var dataDictionary = (0, react_redux_1.useSelector)(function (state) { return state.DataDictionary; });
    var table = getRegressionTable(model);
    if (table === undefined) {
        return (0, jsx_runtime_1.jsx)("div", { children: "Unsupported" });
    }
    var numericPredictor = getNumericPredictorType(table);
    if (numericPredictor === undefined) {
        return (0, jsx_runtime_1.jsx)("div", { children: "Unsupported" });
    }
    var modelName = model.modelName;
    var miningSchema = model.MiningSchema;
    var dependentAxisTitle = miningSchema.MiningField.filter(function (mf) { return mf.usageType === "target"; })[0].name;
    var lines = getLines(table, numericPredictor);
    var rangeY = getYRange(dataDictionary, model);
    if (rangeY === undefined) {
        rangeY = getDefaultYRange(lines);
    }
    var rangeX = getXRange(dataDictionary, numericPredictor);
    if (rangeX === undefined) {
        rangeX = getDefaultXRange(lines, rangeY);
    }
    return ((0, jsx_runtime_1.jsx)("div", { children: (0, jsx_runtime_1.jsx)(LinearRegressionView_1.LinearRegressionView, { modelName: modelName !== null && modelName !== void 0 ? modelName : "<Undefined>", independentAxisTitle: numericPredictor.name, dependentAxisTitle: dependentAxisTitle, lines: lines, rangeX: rangeX, rangeY: rangeY }) }));
};
exports.LinearRegressionViewAdaptor = LinearRegressionViewAdaptor;
var getRegressionTable = function (model) {
    var tables = model.RegressionTable;
    if (tables === undefined || tables.length > 1) {
        return undefined;
    }
    return tables[0];
};
var getNumericPredictorType = function (table) {
    var predicates = table.NumericPredictor;
    if (predicates === undefined || predicates.length > 1) {
        return undefined;
    }
    return predicates[0];
};
var getLines = function (table, numericPredictor) {
    var c = table.intercept;
    var line = { m: numericPredictor.coefficient, c: c, title: "base" };
    var lines = new Array(line);
    var categoricalPredictors = table.CategoricalPredictor;
    if (categoricalPredictors === undefined) {
        return lines;
    }
    categoricalPredictors.forEach(function (cp) {
        lines.push({ m: line.m, c: line.c + cp.coefficient, title: "".concat(line.title, " (").concat(cp.value, ")") });
    });
    return lines;
};
var getYRange = function (dataDictionary, model) {
    var targetField = getTargetMiningField(model);
    if (targetField === undefined) {
        return undefined;
    }
    var targetFieldIntervals = getMiningFieldIntervals(dataDictionary, targetField.name);
    return getIntervalsMaximumRange(targetFieldIntervals);
};
var getTargetMiningField = function (model) {
    var targetFields = model.MiningSchema.MiningField.filter(function (mf) { return mf.usageType === "target"; });
    if (targetFields === undefined || targetFields.length !== 1) {
        return undefined;
    }
    return targetFields[0];
};
var getXRange = function (dataDictionary, numericPredictor) {
    var predictorFieldIntervals = getMiningFieldIntervals(dataDictionary, numericPredictor.name);
    return getIntervalsMaximumRange(predictorFieldIntervals);
};
var getMiningFieldIntervals = function (dataDictionary, fieldName) {
    var dataFields = dataDictionary.DataField.filter(function (df) { return df.name === fieldName && df.optype === "continuous"; });
    if (dataFields === undefined || dataFields.length !== 1) {
        return [];
    }
    var intervals = dataFields[0].Interval;
    if (intervals === undefined) {
        return [];
    }
    return intervals;
};
var getIntervalsMaximumRange = function (intervals) {
    if (intervals.length === 0) {
        return undefined;
    }
    var min = intervals.map(function (interval) { var _a; return (_a = interval.leftMargin) !== null && _a !== void 0 ? _a : 0; }).reduce(function (pv, cv) { return Math.min(pv, cv); });
    var max = intervals.map(function (interval) { var _a; return (_a = interval.rightMargin) !== null && _a !== void 0 ? _a : 0; }).reduce(function (pv, cv) { return Math.max(pv, cv); });
    return new LinearRegressionView_1.Range(min, max);
};
var getDefaultYRange = function (lines) {
    var maxIntersect = Math.max.apply(Math, __spreadArray([], __read(lines.map(function (line) { return line.c; })), false));
    var defaultMaxY = maxIntersect * 2;
    var defaultMinY = -defaultMaxY;
    return new LinearRegressionView_1.Range(defaultMinY, defaultMaxY);
};
var getDefaultXRange = function (lines, rangeY) {
    var minGradient = Math.min.apply(Math, __spreadArray([], __read(lines.map(function (line) { return line.m; })), false));
    var maxIntersect = Math.max.apply(Math, __spreadArray([], __read(lines.map(function (line) { return line.c; })), false));
    var defaultMaxX = (rangeY.max - maxIntersect) / minGradient;
    var defaultMinX = -defaultMaxX;
    return new LinearRegressionView_1.Range(defaultMinX, defaultMaxX);
};
//# sourceMappingURL=LinearRegressionViewAdaptor.js.map