"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Alert_1 = require("@patternfly/react-core/dist/js/components/Alert");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var Radio_1 = require("@patternfly/react-core/dist/js/components/Radio");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
var arrow_alt_circle_left_icon_1 = require("@patternfly/react-icons/dist/js/icons/arrow-alt-circle-left-icon");
var DataDictionaryContainer_1 = require("../DataDictionaryContainer/DataDictionaryContainer");
var ConstraintsEdit_1 = require("../ConstraintsEdit/ConstraintsEdit");
require("./DataDictionaryPropertiesEdit.scss");
var DataDictionaryPropertiesEdit = function (props) {
    var _a, _b, _c;
    var dataType = props.dataType, dataFieldIndex = props.dataFieldIndex, onClose = props.onClose, onSave = props.onSave;
    var _d = __read((0, react_1.useState)((_a = dataType.displayName) !== null && _a !== void 0 ? _a : ""), 2), displayName = _d[0], setDisplayName = _d[1];
    var _e = __read((0, react_1.useState)(dataType.isCyclic), 2), isCyclic = _e[0], setIsCyclic = _e[1];
    var _f = __read((0, react_1.useState)((_b = dataType.missingValue) !== null && _b !== void 0 ? _b : ""), 2), missingValue = _f[0], setMissingValue = _f[1];
    var _g = __read((0, react_1.useState)((_c = dataType.invalidValue) !== null && _c !== void 0 ? _c : ""), 2), invalidValue = _g[0], setInvalidValue = _g[1];
    (0, react_1.useEffect)(function () {
        var _a, _b, _c;
        setDisplayName((_a = dataType.displayName) !== null && _a !== void 0 ? _a : "");
        setIsCyclic(dataType.isCyclic);
        setMissingValue((_b = dataType.missingValue) !== null && _b !== void 0 ? _b : "");
        setInvalidValue((_c = dataType.invalidValue) !== null && _c !== void 0 ? _c : "");
    }, [dataType]);
    var saveCyclicProperty = function (value) {
        setIsCyclic(value);
        onSave({
            isCyclic: value,
        });
    };
    var isOptypeDisabled = (0, react_1.useMemo)(function () { return dataType.optype === "categorical"; }, [dataType.optype]);
    var constraintAlert = (0, react_1.useMemo)(function () {
        var _a, _b;
        if (dataType.optype === "continuous" && dataType.isCyclic && dataType.constraints === undefined) {
            return "Interval or Value constraints are required for cyclic continuous data types";
        }
        if (dataType.isCyclic &&
            dataType.optype === "continuous" &&
            ((_a = dataType.constraints) === null || _a === void 0 ? void 0 : _a.type) === DataDictionaryContainer_1.ConstraintType.RANGE &&
            ((_b = dataType.constraints.value) === null || _b === void 0 ? void 0 : _b.length) > 1) {
            return "Cyclic continuous data types can only have a single interval constraint";
        }
    }, [dataType]);
    return ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true, className: "data-dictionary__properties-edit" }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Title_1.Title, __assign({ headingLevel: "h4", size: Title_1.TitleSizes.xl }, { children: [(0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "link", isInline: true, onClick: onClose }, { children: dataType.name })), "\u00A0/\u00A0Properties"] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, __assign({ className: "data-dictionary__properties-edit__form-container", "data-ouia-component-id": "df-props", "data-ouia-component-type": "editor-body" }, { children: (0, jsx_runtime_1.jsx)(Form_1.Form, __assign({ className: "data-dictionary__properties-edit__form" }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ className: "data-dictionary__properties-edit__form__left-column" }, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "data-dictionary__properties-edit__field", label: "Display Name", fieldId: "display-name", helperText: "Display Name to use instead of the data type name" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "display-name", name: "display-name", "aria-describedby": "Display Name", value: displayName, onChange: function (value) { return setDisplayName(value); }, autoComplete: "off", onBlur: function () {
                                                        return onSave({
                                                            displayName: displayName === "" ? undefined : displayName,
                                                        });
                                                    }, ouiaId: "display-name" }) })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Form_1.FormGroup, __assign({ className: "data-dictionary__properties-edit__field", label: "Cyclic Type", fieldId: "is-cyclic", isInline: true, labelIcon: dataType.optype === "categorical" ? ((0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Categorical fields cannot be cyclic" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info for Cyclic Type", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) }))) : ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {})) }, { children: [(0, jsx_runtime_1.jsx)(Radio_1.Radio, { isChecked: isCyclic === true, name: "isCyclic", onChange: function () {
                                                            saveCyclicProperty(true);
                                                        }, label: "Yes", id: "isCyclic", value: "isCyclic", isDisabled: isOptypeDisabled }), (0, jsx_runtime_1.jsx)(Radio_1.Radio, { isChecked: isCyclic === false, name: "isNotCyclic", onChange: function () {
                                                            saveCyclicProperty(false);
                                                        }, label: "No", id: "isNotCyclic", value: "isNotCyclic", isDisabled: isOptypeDisabled }), (0, jsx_runtime_1.jsx)(Radio_1.Radio, { isChecked: isCyclic === undefined, name: "cyclicNotSet", onChange: function () {
                                                            saveCyclicProperty(undefined);
                                                        }, label: "Not Set", id: "cyclicNotSet", value: "cyclicNotSet", isDisabled: isOptypeDisabled })] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "data-dictionary__properties-edit__field", label: "Missing Value", fieldId: "missing-value", helperText: "Value for when the input is missing" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "missing-value", name: "missing-value", "aria-describedby": "Missing Value", value: missingValue, onChange: function (value) { return setMissingValue(value); }, autoComplete: "off", onBlur: function () {
                                                        return onSave({
                                                            missingValue: missingValue === "" ? undefined : missingValue,
                                                        });
                                                    }, ouiaId: "missing-value" }) })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ className: "data-dictionary__properties-edit__field", label: "Invalid Value", fieldId: "missing-value", helperText: "Value for when the input is invalid" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "invalid-value", name: "invalid-value", "aria-describedby": "Invalid Value", value: invalidValue, onChange: function (value) { return setInvalidValue(value); }, autoComplete: "off", onBlur: function () {
                                                        return onSave({
                                                            invalidValue: invalidValue === "" ? undefined : invalidValue,
                                                        });
                                                    }, ouiaId: "invalid-value" }) })) })] })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsxs)("section", __assign({ className: "data-dictionary__constraints-section" }, { children: [constraintAlert && ((0, jsx_runtime_1.jsx)(Alert_1.Alert, { variant: "warning", isInline: true, className: "data-dictionary__validation-alert", title: constraintAlert })), (0, jsx_runtime_1.jsx)(ConstraintsEdit_1.default, { dataType: dataType, dataFieldIndex: dataFieldIndex, onSave: onSave })] })) }))] })) })) })), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: onClose, icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_left_icon_1.ArrowAltCircleLeftIcon, {}), iconPosition: "left", ouiaId: "back-to-DFs" }, { children: "Back" })) })] })));
};
exports.default = DataDictionaryPropertiesEdit;
//# sourceMappingURL=DataDictionaryPropertiesEdit.js.map