import { Position } from "vscode-languageserver-types";
export declare type EditorLanguageServiceCommandTypes<T extends string = never> = T | "editor.ls.commands.OpenCompletionItems";
export declare type EditorLanguageServiceCommandArgs = {
    "editor.ls.commands.OpenCompletionItems": {
        newCursorPosition: Position;
    };
};
export declare type EditorLanguageServiceCommandIds<T extends string> = Record<T, string>;
export declare type EditorLanguageServiceCommandHandlers<T extends keyof A, A extends EditorLanguageServiceCommandArgs> = {
    [K in T]: (args: A[K]) => any;
};
export interface EditorLanguageServiceCommandExecution<T extends keyof A, A extends EditorLanguageServiceCommandArgs> {
    name: T;
    args: A[T];
}
//# sourceMappingURL=EditorLanguageServiceChannelApi.d.ts.map