"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeServerlessWorkflowDiagramEditorFactory = void 0;
var DiagramService_1 = require("../../api/DiagramService");
var envelope_1 = require("../../envelope");
var JavaCodeCompletionService = (function () {
    function JavaCodeCompletionService(envelopeContext) {
        this.envelopeContext = envelopeContext;
    }
    JavaCodeCompletionService.prototype.getAccessors = function (fqcn, query) {
        return this.envelopeContext.channelApi.requests.kogitoJavaCodeCompletion__getAccessors(fqcn, query);
    };
    JavaCodeCompletionService.prototype.getClasses = function (query) {
        return this.envelopeContext.channelApi.requests.kogitoJavaCodeCompletion__getClasses(query);
    };
    JavaCodeCompletionService.prototype.isLanguageServerAvailable = function () {
        return this.envelopeContext.channelApi.requests.kogitoJavaCodeCompletion__isLanguageServerAvailable();
    };
    return JavaCodeCompletionService;
}());
var VsCodeServerlessWorkflowDiagramEditorFactory = (function () {
    function VsCodeServerlessWorkflowDiagramEditorFactory(gwtEditorEnvelopeConfig) {
        this.gwtEditorEnvelopeConfig = gwtEditorEnvelopeConfig;
    }
    VsCodeServerlessWorkflowDiagramEditorFactory.prototype.createEditor = function (ctx, initArgs) {
        var _a;
        window.envelope = __assign(__assign(__assign({}, ((_a = window.envelope) !== null && _a !== void 0 ? _a : {})), { javaCodeCompletionService: new JavaCodeCompletionService(ctx) }), { diagramService: new DiagramService_1.DiagramService(ctx) });
        var factory = new envelope_1.ServerlessWorkflowDiagramEditorFactory(this.gwtEditorEnvelopeConfig);
        return factory.createEditor(ctx, initArgs);
    };
    return VsCodeServerlessWorkflowDiagramEditorFactory;
}());
exports.VsCodeServerlessWorkflowDiagramEditorFactory = VsCodeServerlessWorkflowDiagramEditorFactory;
//# sourceMappingURL=VsCodeServerlessWorkflowDiagramEditorFactory.js.map