export interface StunnerEditorEnvelopeAPI {
    editor_session_getAllNodesUUID(): Promise<string[]>;
    editor_session_getEdgeByUUID(uuid: string): Promise<Edge>;
    editor_session_getNodeByUUID(uuid: string): Promise<Node>;
    editor_session_getDefinitionByElementUUID(uuid: string): Promise<Object>;
    editor_session_getNodeByName(name: string): Promise<Node>;
    editor_session_getNodeName(node: Node): Promise<string>;
    editor_session_getSelectedElementUUID(): Promise<string>;
    editor_session_getSelectedNode(): Promise<Node>;
    editor_session_getSelectedEdge(): Promise<Edge>;
    editor_session_getSelectedDefinition(): Promise<Object>;
    editor_session_selectByUUID(uuid: string): Promise<void>;
    editor_session_selectByName(name: string): Promise<void>;
    editor_session_clearSelection(): Promise<void>;
    editor_canvas_getShapeIds(): Promise<string[]>;
    editor_canvas_getBackgroundColor(uuid: string): Promise<string>;
    editor_canvas_setBackgroundColor(uuid: string, backgroundColor: string): Promise<void>;
    editor_canvas_getBorderColor(uuid: string): Promise<string>;
    editor_canvas_setBorderColor(uuid: string, borderColor: string): Promise<void>;
    editor_canvas_getLocation(uuid: string): Promise<number[]>;
    editor_canvas_getAbsoluteLocation(uuid: string): Promise<number[]>;
    editor_canvas_getDimensions(uuid: string): Promise<number[]>;
    editor_canvas_center(uuid: string): Promise<void>;
    editor_canvas_draw(): Promise<void>;
}
export declare class Element {
    uuid: string;
    definition: Definition;
}
export declare class Node extends Element {
    inEdges: Edge[];
    outEdges: Edge[];
}
export declare class Edge extends Element {
    source: string;
    target: string;
}
export declare class Definition {
    id: string;
    name: string;
}
//# sourceMappingURL=StunnerEditorEnvelopeAPI.d.ts.map