var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Dropdown, DropdownToggle, DropdownItem } from "@patternfly/react-core/dist/js/components/Dropdown";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import React, { useState, useEffect } from "react";
import { CaretDownIcon } from "@patternfly/react-icons/dist/js/icons/caret-down-icon";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import WorkflowDetailsErrorModal from "../WorkflowDetailsErrorModal/WorkflowDetailsErrorModal";
import "../styles.css";
const WorkflowDetailsNodeTrigger = ({ workflowInstanceData, driver, ouiaId, ouiaSafe, }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [selectedNode, setSelectedNode] = useState();
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [modalTitle, setModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [modalContent, setModalContent] = useState("");
    const [isError, setIsError] = useState(false);
    const [nodes, setNodes] = useState([]);
    useEffect(() => {
        (() => __awaiter(void 0, void 0, void 0, function* () {
            yield driver
                .getTriggerableNodes(workflowInstanceData)
                .then((nodeInstances) => {
                setIsError(false);
                setNodes(nodeInstances);
            })
                .catch((error) => {
                setIsError(true);
                setModalTitle("Node trigger Error");
                setModalContent(`Retrieval of nodes failed with error: ${error.message}`);
                setTitleType("failure");
                handleModalToggle();
            });
        }))();
    }, []);
    const handleModalToggle = () => {
        setIsModalOpen(!isModalOpen);
    };
    const onSelect = (event) => {
        setIsOpen(!isOpen);
        getSelectedNode(event.currentTarget.id);
    };
    const onToggle = (isDropDownOpen) => {
        setIsOpen(isDropDownOpen);
    };
    const getSelectedNode = (selectedNodeName) => {
        if (nodes.length > 0) {
            const selectedNodeObject = nodes.filter((node) => node.id === selectedNodeName);
            setSelectedNode(selectedNodeObject[0]);
        }
    };
    const createNodeDropDown = () => {
        const nodeDropDown = [];
        nodes.length > 0 &&
            nodes.forEach((node) => {
                node.type !== null &&
                    node.type !== "StartNode" &&
                    node.type !== "Join" &&
                    nodeDropDown.push(React.createElement(DropdownItem, { key: node.id, id: node.id }, node.name));
            });
        return nodeDropDown;
    };
    const onTriggerClick = () => {
        setModalTitle("Node trigger workflow");
        driver
            .handleNodeTrigger(workflowInstanceData, selectedNode)
            .then(() => {
            setTitleType("success");
            setModalContent(`The node ${selectedNode.name} was triggered successfully`);
        })
            .catch((error) => {
            setTitleType("failure");
            setModalContent(`The node ${selectedNode.name} trigger failed. ErrorMessage : ${error.message}`);
        })
            .finally(() => {
            handleModalToggle();
        });
    };
    const errorModalAction = [
        React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: handleModalToggle }, "OK"),
    ];
    return (React.createElement(React.Fragment, null,
        React.createElement(WorkflowDetailsErrorModal, { errorString: modalContent, errorModalOpen: isModalOpen, errorModalAction: errorModalAction, handleErrorModal: handleModalToggle, label: "Node Trigger Error", title: setTitle(titleType, modalTitle) }),
        !isError ? (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "node-trigger", ouiaSafe)),
            React.createElement(CardHeader, null,
                React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Node Trigger")),
            React.createElement(CardHeader, null,
                React.createElement("div", null, "Select a node from the workflow nodes list and click Trigger to launch it manually.")),
            React.createElement(CardBody, null,
                React.createElement("div", null,
                    React.createElement(Dropdown, { direction: "up", onSelect: onSelect, toggle: React.createElement(DropdownToggle, { id: "toggle-id", "data-testid": "toggle-id", onToggle: onToggle, toggleIndicator: CaretDownIcon }, selectedNode ? selectedNode.name : "select a node"), isOpen: isOpen, dropdownItems: createNodeDropDown() })),
                selectedNode && (React.createElement(React.Fragment, null,
                    React.createElement("div", { className: "pf-u-mt-md" },
                        React.createElement(Flex, { direction: { default: "column" } },
                            React.createElement(FlexItem, null,
                                React.createElement(TextContent, null,
                                    " ",
                                    React.createElement(Split, { hasGutter: true },
                                        React.createElement(SplitItem, null,
                                            React.createElement(Text, { component: TextVariants.h6 }, "Node name : ")),
                                        React.createElement(SplitItem, null,
                                            React.createElement(Text, { component: TextVariants.p }, selectedNode.name))))),
                            React.createElement(FlexItem, null,
                                React.createElement(TextContent, null,
                                    " ",
                                    React.createElement(Split, { hasGutter: true },
                                        React.createElement(SplitItem, null,
                                            React.createElement(Text, { component: TextVariants.h6 }, "Node type : ")),
                                        React.createElement(SplitItem, null,
                                            React.createElement(Text, { component: TextVariants.p }, selectedNode.type))))),
                            React.createElement(FlexItem, null,
                                React.createElement(TextContent, null,
                                    " ",
                                    React.createElement(Split, { hasGutter: true },
                                        React.createElement(SplitItem, null,
                                            React.createElement(Text, { component: TextVariants.h6 }, "Node id : ")),
                                        React.createElement(SplitItem, null,
                                            React.createElement(Text, { component: TextVariants.p }, selectedNode.id))))))))),
                React.createElement("div", { className: "pf-u-mt-md" },
                    React.createElement(Button, { variant: "secondary", onClick: onTriggerClick, id: "trigger", "data-testid": "trigger", isDisabled: !selectedNode }, "Trigger"))))) : (React.createElement(React.Fragment, null))));
};
export default WorkflowDetailsNodeTrigger;
//# sourceMappingURL=WorkflowDetailsNodeTrigger.js.map