import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { FormDetailsChannelApiImpl } from "./FormDetailsChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedFormDetails = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
            targetOrigin: props.targetOrigin,
        });
        return envelopeServer.envelopeApi.requests.formDetails__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, Object.assign({}, props.formData));
    }, []);
    return (React.createElement(EmbeddedFormDetailsEnvelope, { ref: forwardedRef, apiImpl: new FormDetailsChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedFormDetailsEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedFormDetails.js.map