import React, { useImperativeHandle, useState } from "react";
import CustomDashboardList from "./components/CustomDashboardList/CustomDashboardList";
import CustomDashboardListEnvelopeViewDriver from "./CustomDashboardListEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const CustomDashboardListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    useImperativeHandle(forwardedRef, () => ({
        initialize: () => {
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (React.createElement(React.Fragment, null,
        React.createElement(CustomDashboardList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new CustomDashboardListEnvelopeViewDriver(props.channelApi) })));
});
export default CustomDashboardListEnvelopeView;
//# sourceMappingURL=CustomDashboardListEnvelopeView.js.map