import { DAYS_AND_TIME_DURATION_FORMAT, YEARS_AND_MONTHS_DURATION_FORMAT } from "@kie-tools/dmn-runner/dist/dmnFormats";
import { UnitablesJsonSchemaBridge } from "@kie-tools/unitables/dist/uniforms";
import { X_DMN_TYPE } from "@kie-tools/extended-services-api";
export class DmnUnitablesJsonSchemaBridge extends UnitablesJsonSchemaBridge {
    getField(name) {
        const field = super.getField(name);
        if (field.format === DAYS_AND_TIME_DURATION_FORMAT) {
            field.placeholder = "P1DT5H or P2D or PT1H2M10S";
        }
        if (field.format === YEARS_AND_MONTHS_DURATION_FORMAT) {
            field.placeholder = "P1Y5M or P2Y or P1M";
        }
        if (field["x-dmn-type"] === X_DMN_TYPE.CONTEXT) {
            field.placeholder = `{ "x": <value> }`;
        }
        return field;
    }
    getFieldDataType(field) {
        return super.getFieldDataType(field);
    }
}
//# sourceMappingURL=DmnUnitablesJsonSchemaBridge.js.map