import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Text, TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { CubeIcon } from "@patternfly/react-icons/dist/js/icons/cube-icon";
import { ExclamationIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-icon";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import nextId from "react-id-generator";
import { useDmnRunnerOutputs as useDmnRunnerOutputs } from "./DmnRunnerOutputs";
import { BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, generateUuid, } from "@kie-tools/boxed-expression-component/dist/api";
import { getColumnsAtLastLevel } from "@kie-tools/boxed-expression-component/dist/table/BeeTable";
import { StandaloneBeeTable } from "@kie-tools/boxed-expression-component/dist/table/BeeTable/StandaloneBeeTable";
import "@kie-tools/boxed-expression-component/dist/@types/react-table";
import { ResizerStopBehavior } from "@kie-tools/boxed-expression-component/dist/resizing/ResizingWidthsContext";
import "./DmnRunnerOutputsTable.css";
export function DmnRunnerOutputsTable({ i18n, jsonSchemaBridge, results, scrollableParentRef }) {
    const outputUid = useMemo(() => nextId(), []);
    const outputErrorBoundaryRef = useRef(null);
    const [outputError, setOutputError] = useState(false);
    const { outputsPropertiesMap } = useDmnRunnerOutputs(jsonSchemaBridge, results);
    useEffect(() => {
        var _a;
        (_a = outputErrorBoundaryRef.current) === null || _a === void 0 ? void 0 : _a.reset();
    }, [outputsPropertiesMap]);
    const numberOfResults = useMemo(() => { var _a; return (_a = results === null || results === void 0 ? void 0 : results.reduce((acc, result) => { var _a; return acc + ((_a = result === null || result === void 0 ? void 0 : result.length) !== null && _a !== void 0 ? _a : 0); }, 0)) !== null && _a !== void 0 ? _a : 0; }, [results]);
    return (_jsx(_Fragment, { children: outputError ? (outputError) : numberOfResults > 0 ? (_jsx(ErrorBoundary, Object.assign({ ref: outputErrorBoundaryRef, setHasError: setOutputError, error: _jsx(OutputError, {}) }, { children: _jsx(OutputsBeeTable, { scrollableParentRef: scrollableParentRef, i18n: i18n, outputsPropertiesMap: outputsPropertiesMap, results: results, id: outputUid }) }))) : (_jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubeIcon }), _jsx(TextContent, { children: _jsx(Text, Object.assign({ component: "h2" }, { children: "No Decision results yet..." })) }), _jsx(EmptyStateBody, { children: _jsx(TextContent, { children: "Add input and decision nodes, provide values to the inputs at the left and see the Decisions results here." }) })] })) }));
}
function OutputError() {
    return (_jsx("div", { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: ExclamationIcon }), _jsx(TextContent, { children: _jsx(Text, Object.assign({ component: "h2" }, { children: "Error" })) }), _jsx(EmptyStateBody, { children: _jsx("p", { children: "An error has happened while trying to show your Decision results" }) })] }) }));
}
export const DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH = 150;
const EMPTY_SYMBOL = "";
function OutputsBeeTable({ id, i18n, outputsPropertiesMap, results, scrollableParentRef }) {
    const beeTableOperationConfig = useMemo(() => [
        {
            group: i18n.terms.selection.toUpperCase(),
            items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
        },
    ], [i18n]);
    const uuid = useMemo(() => {
        return generateUuid();
    }, []);
    const deepFlattenObjectColumn = useCallback((myObject, propertiesTypes, parentKey) => {
        return Object.entries(myObject).flatMap(([myObjectKey, value]) => {
            var _a, _b, _c, _d;
            if (value !== null && typeof value === "object") {
                const myKey = parentKey ? `${parentKey}-${myObjectKey}` : myObjectKey;
                return deepFlattenObjectColumn(value, (_b = (_a = propertiesTypes === null || propertiesTypes === void 0 ? void 0 : propertiesTypes[myObjectKey]) === null || _a === void 0 ? void 0 : _a.properties) !== null && _b !== void 0 ? _b : (_c = propertiesTypes === null || propertiesTypes === void 0 ? void 0 : propertiesTypes[myObjectKey]) === null || _c === void 0 ? void 0 : _c.items, myKey);
            }
            const label = parentKey ? `${parentKey}-${myObjectKey}` : myObjectKey;
            const myObjectProperties = (_d = propertiesTypes === null || propertiesTypes === void 0 ? void 0 : propertiesTypes[myObjectKey]) !== null && _d !== void 0 ? _d : propertiesTypes;
            const dataType = myObjectProperties ? myObjectProperties.type : DmnBuiltInDataType.Any;
            return {
                originalId: label + generateUuid(),
                label,
                accessor: (`output-object-${label}` + generateUuid()),
                dataType,
                isRowIndexColumn: false,
                groupType: "dmn-runner-output",
                width: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
            };
        });
    }, []);
    const getRowValue = useCallback((value) => {
        if (value === undefined) {
            return;
        }
        else if (value === null) {
            return "null";
        }
        else if (Array.isArray(value)) {
            return value.map((element) => JSON.stringify(element, null, 2).replace(/"([^"]+)":/g, "$1:"));
        }
        else {
            return JSON.stringify(value);
        }
    }, []);
    const deepFlattenObjectRow = useCallback((myObject, parentKey, flattenedObject) => {
        return Object.entries(myObject).reduce((acc, [myObjectKey, value]) => {
            const myKey = parentKey ? `${parentKey}-${myObjectKey}` : myObjectKey;
            if (value !== null && !Array.isArray(value) && typeof value === "object") {
                return deepFlattenObjectRow(value, myKey, acc);
            }
            if (value !== null && Array.isArray(value)) {
                return value.reduce((acc, v, index) => {
                    if (v !== null && !Array.isArray(v) && typeof v === "object") {
                        return Object.assign(Object.assign({}, acc), deepFlattenObjectRow(v, `${myKey}-${index}`, acc));
                    }
                    else {
                        const rowValue = getRowValue(v);
                        if (rowValue) {
                            acc[`${myKey}-${index}`] = rowValue;
                        }
                        return acc;
                    }
                }, acc);
            }
            const rowValue = getRowValue(value);
            if (rowValue) {
                acc[myKey] = rowValue;
            }
            return acc;
        }, flattenedObject !== null && flattenedObject !== void 0 ? flattenedObject : {});
    }, [getRowValue]);
    const beeTableColumns = useMemo(() => {
        var _a;
        return ((_a = results === null || results === void 0 ? void 0 : results[0]) !== null && _a !== void 0 ? _a : []).flatMap(({ result, decisionName }) => {
            var _a, _b, _c, _d, _e, _f, _g;
            const outputProperties = outputsPropertiesMap.get(decisionName);
            if (!outputProperties) {
                return [];
            }
            if ((outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.dataType) === "context") {
                const collectedOutputs = results === null || results === void 0 ? void 0 : results.flatMap((result) => {
                    var _a;
                    return (_a = result === null || result === void 0 ? void 0 : result.filter((decisionResult) => decisionResult.decisionName === outputProperties.joinedName)) === null || _a === void 0 ? void 0 : _a.flatMap((decisionResult) => decisionResult.result);
                });
                return [
                    {
                        originalId: `${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid(),
                        label: (_a = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name) !== null && _a !== void 0 ? _a : "",
                        accessor: (`output-object-parent-${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid()),
                        dataType: outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.dataType,
                        isRowIndexColumn: false,
                        groupType: "dmn-runner-output",
                        minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                        columns: (_b = collectedOutputs === null || collectedOutputs === void 0 ? void 0 : collectedOutputs.flatMap((collectedOutput) => {
                            var _a;
                            if (collectedOutput !== null && typeof collectedOutput === "object") {
                                return deepFlattenObjectColumn(collectedOutput, outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.properties);
                            }
                            return {
                                originalId: "context-" + generateUuid(),
                                label: "context",
                                accessor: (`output-context-` + generateUuid()),
                                dataType: (_a = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.dataType) !== null && _a !== void 0 ? _a : DmnBuiltInDataType.Any,
                                isRowIndexColumn: false,
                                groupType: "dmn-runner-output",
                                width: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                                minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                            };
                        }).reduce((acc, column) => {
                            if (acc.find((e) => e.label === column.label)) {
                                return acc;
                            }
                            if (outputProperties) {
                                outputsPropertiesMap === null || outputsPropertiesMap === void 0 ? void 0 : outputsPropertiesMap.set(outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name, outputProperties);
                            }
                            return [...acc, column];
                        }, [])) !== null && _b !== void 0 ? _b : [],
                    },
                ];
            }
            if (typeof result === "string" || typeof result === "number" || typeof result === "boolean" || result === null) {
                return [
                    {
                        originalId: `parent-${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid(),
                        label: "",
                        accessor: (`output-parent-${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid()),
                        dataType: undefined,
                        isRowIndexColumn: false,
                        groupType: "dmn-runner-output",
                        minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                        columns: [
                            {
                                originalId: `${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid(),
                                label: (_c = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name) !== null && _c !== void 0 ? _c : "",
                                accessor: (`output-${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid()),
                                dataType: (_d = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.dataType) !== null && _d !== void 0 ? _d : DmnBuiltInDataType.Undefined,
                                isRowIndexColumn: false,
                                groupType: "dmn-runner-output",
                                width: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                                minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                            },
                        ],
                    },
                ];
            }
            if (Array.isArray(result)) {
                return [
                    {
                        originalId: `${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid(),
                        label: `${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}`,
                        accessor: (`output-array-parent-${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid()),
                        dataType: (_e = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.dataType) !== null && _e !== void 0 ? _e : DmnBuiltInDataType.Undefined,
                        isRowIndexColumn: false,
                        groupType: "dmn-runner-output",
                        columns: result.map((entry, entryIndex) => ({
                            originalId: `${entryIndex}-` + generateUuid(),
                            label: `[${entryIndex}]`,
                            accessor: (`output-array-${entryIndex}-` + generateUuid()),
                            dataType: undefined,
                            groupType: "dmn-runner-output",
                            isRowIndexColumn: false,
                            width: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                            minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                        })),
                    },
                ];
            }
            if (typeof result === "object") {
                return [
                    {
                        originalId: `${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid(),
                        label: (_f = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name) !== null && _f !== void 0 ? _f : "",
                        accessor: (`output-object-parent-${outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.name}-` + generateUuid()),
                        dataType: (_g = outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.dataType) !== null && _g !== void 0 ? _g : DmnBuiltInDataType.Undefined,
                        isRowIndexColumn: false,
                        groupType: "dmn-runner-output",
                        minWidth: DMN_RUNNER_OUTPUT_COLUMN_MIN_WIDTH,
                        columns: deepFlattenObjectColumn(result, outputProperties === null || outputProperties === void 0 ? void 0 : outputProperties.properties),
                    },
                ];
            }
            return [];
        });
    }, [deepFlattenObjectColumn, outputsPropertiesMap, results]);
    const beeTableRows = useMemo(() => {
        return (results !== null && results !== void 0 ? results : []).map((decisionResult, rowIndex) => {
            const rowValues = decisionResult === null || decisionResult === void 0 ? void 0 : decisionResult.flatMap(({ result, decisionName }) => {
                var _a, _b;
                const headerColumn = beeTableColumns.find((column) => {
                    var _a, _b;
                    if (column.label === "") {
                        return ((_b = (_a = column.columns) === null || _a === void 0 ? void 0 : _a.findIndex((subHeader) => subHeader.label === decisionName)) !== null && _b !== void 0 ? _b : -1) > -1;
                    }
                    return column.label === decisionName;
                });
                if (!headerColumn) {
                    return [];
                }
                let columnResults;
                if (result !== null && !Array.isArray(result) && typeof result === "object") {
                    columnResults = deepFlattenObjectRow(result);
                }
                else {
                    if (headerColumn.dataType === "context") {
                        columnResults = { context: getRowValue(result) };
                    }
                    else {
                        columnResults = { [`${decisionName}`]: getRowValue(result) };
                    }
                }
                return (_b = (_a = headerColumn.columns) === null || _a === void 0 ? void 0 : _a.map((column) => columnResults[column.label])) !== null && _b !== void 0 ? _b : [];
            }, []);
            return getColumnsAtLastLevel(beeTableColumns).reduce((tableRow, column, columnIndex) => {
                var _a;
                tableRow[column.accessor] = (_a = rowValues === null || rowValues === void 0 ? void 0 : rowValues[columnIndex]) !== null && _a !== void 0 ? _a : EMPTY_SYMBOL;
                tableRow.id = uuid + "-" + rowIndex;
                return tableRow;
            }, {});
        });
    }, [results, beeTableColumns, getRowValue, deepFlattenObjectRow, uuid]);
    const getColumnKey = useCallback((column) => {
        var _a;
        return (_a = column.originalId) !== null && _a !== void 0 ? _a : column.id;
    }, []);
    const getRowKey = useCallback((row) => {
        return row.original.id;
    }, []);
    const allowedOperations = useCallback((conditions) => {
        return [BeeTableOperation.SelectionCopy];
    }, []);
    return (_jsx(StandaloneBeeTable, { scrollableParentRef: scrollableParentRef, allowedOperations: allowedOperations, getColumnKey: getColumnKey, getRowKey: getRowKey, tableId: id, isEditableHeader: false, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: BeeTableHeaderVisibility.AllLevels, operationConfig: beeTableOperationConfig, columns: beeTableColumns, rows: beeTableRows, isReadOnly: true, enableKeyboardNavigation: true, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_ALWAYS }));
}
//# sourceMappingURL=DmnRunnerOutputsTable.js.map