import { useMemo } from "react";
export function useDmnRunnerOutputs(jsonSchemaBridge, results) {
    return useMemo(() => {
        var _a, _b, _c;
        if (jsonSchemaBridge === undefined || results === undefined) {
            return { outputsPropertiesMap: new Map() };
        }
        const outputsPropertiesMap = Object.entries((_c = (_b = (_a = jsonSchemaBridge.schema.definitions) === null || _a === void 0 ? void 0 : _a.OutputSet) === null || _b === void 0 ? void 0 : _b.properties) !== null && _c !== void 0 ? _c : []).reduce((outputTypeMap, [name, properties]) => {
            const dataType = jsonSchemaBridge.getFieldDataType(properties).dataType;
            outputTypeMap.set(name, {
                type: properties.type,
                dataType,
                name,
                joinedName: name,
                properties: properties.properties,
                items: properties.items,
            });
            return outputTypeMap;
        }, new Map());
        return {
            outputsPropertiesMap,
        };
    }, [jsonSchemaBridge, results]);
}
//# sourceMappingURL=DmnRunnerOutputs.js.map