var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Fragment as _Fragment, jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Dropdown, DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Menu } from "@patternfly/react-core/dist/js/components/Menu/Menu";
import { MenuGroup } from "@patternfly/react-core/dist/js/components/Menu/MenuGroup";
import { MenuItem } from "@patternfly/react-core/dist/js/components/Menu/MenuItem";
import { MenuList } from "@patternfly/react-core/dist/js/components/Menu/MenuList";
import { CompressIcon } from "@patternfly/react-icons/dist/js/icons/compress-icon";
import { CopyIcon } from "@patternfly/react-icons/dist/js/icons/copy-icon";
import { CutIcon } from "@patternfly/react-icons/dist/js/icons/cut-icon";
import { ListIcon } from "@patternfly/react-icons/dist/js/icons/list-icon";
import { PasteIcon } from "@patternfly/react-icons/dist/js/icons/paste-icon";
import { TableIcon } from "@patternfly/react-icons/dist/js/icons/table-icon";
import { RebootingIcon } from "@patternfly/react-icons/dist/js/icons/rebooting-icon";
import { ResourcesAlmostEmptyIcon } from "@patternfly/react-icons/dist/js/icons/resources-almost-empty-icon";
import { ResourcesFullIcon } from "@patternfly/react-icons/dist/js/icons/resources-full-icon";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import { useCustomContextMenuHandler } from "../../contextMenu";
import { MenuItemWithHelp } from "../../contextMenu/MenuWithHelp";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useNestedExpressionContainer } from "../../resizing/NestedExpressionContainerContext";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { ContextExpression } from "../ContextExpression/ContextExpression";
import { DecisionTableExpression } from "../DecisionTableExpression/DecisionTableExpression";
import { FunctionExpression } from "../FunctionExpression/FunctionExpression";
import { InvocationExpression } from "../InvocationExpression/InvocationExpression";
import { ListExpression } from "../ListExpression/ListExpression";
import { LiteralExpression } from "../LiteralExpression/LiteralExpression";
import { RelationExpression } from "../RelationExpression/RelationExpression";
import { buildClipboardFromExpression, DMN_BOXED_EXPRESSION_CLIPBOARD_MIME_TYPE, } from "../../clipboard/clipboard";
import { findAllIdsDeep, mutateExpressionRandomizingIds } from "../../ids/ids";
import "./ExpressionDefinitionLogicTypeSelector.css";
import { NavigationKeysUtils } from "../../keysUtils/keyUtils";
import { ConditionalExpression } from "../ConditionalExpression/ConditionalExpression";
import { IteratorExpressionComponent } from "../IteratorExpression/IteratorExpressionComponent";
import { FilterExpressionComponent } from "../FilterExpression/FilterExpressionComponent";
import FilterIcon from "@patternfly/react-icons/dist/esm/icons/filter-icon";
const DEFAULT_LOGIC_TYPE_SELECTOR_HEIGHT = 550;
const LOGIC_TYPE_SELECTOR_BOTTOM_MARGIN = 5;
const PASTE_MENU_ITEM_ID = "paste";
export function ExpressionDefinitionLogicTypeSelector({ expression, onLogicTypeSelected, onLogicTypeReset, isResetSupported, isNested, parentElementId, hideDmn14BoxedExpressions, }) {
    var _a, _b;
    const nonSelectableLogicTypes = useMemo(() => (isNested ? new Set([undefined]) : new Set([undefined, "functionDefinition"])), [isNested]);
    const { i18n } = useBoxedExpressionEditorI18n();
    const { setCurrentlyOpenContextMenu, widthsById, scrollableParentRef } = useBoxedExpressionEditor();
    const [isOpen, setOpen] = useState(false);
    const [position, setPosition] = useState({ x: 0, y: 0 });
    const showSelectExpression = useCallback((e) => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        setPosition({
            x: e.pageX +
                ((_b = (_a = scrollableParentRef.current) === null || _a === void 0 ? void 0 : _a.offsetLeft) !== null && _b !== void 0 ? _b : 0) -
                ((_d = (_c = scrollableParentRef.current) === null || _c === void 0 ? void 0 : _c.getBoundingClientRect().left) !== null && _d !== void 0 ? _d : 0),
            y: e.pageY +
                ((_f = (_e = scrollableParentRef.current) === null || _e === void 0 ? void 0 : _e.offsetTop) !== null && _f !== void 0 ? _f : 0) -
                ((_h = (_g = scrollableParentRef.current) === null || _g === void 0 ? void 0 : _g.getBoundingClientRect().top) !== null && _h !== void 0 ? _h : 0),
        });
        setOpen(true);
    }, [scrollableParentRef]);
    const selectableLogicTypes = useMemo(() => [
        "literalExpression",
        "relation",
        "context",
        "decisionTable",
        "list",
        "invocation",
        ...(isNested ? ["functionDefinition"] : []),
        ...(!hideDmn14BoxedExpressions ? ["conditional"] : []),
        ...(!hideDmn14BoxedExpressions ? ["for"] : []),
        ...(!hideDmn14BoxedExpressions ? ["every"] : []),
        ...(!hideDmn14BoxedExpressions ? ["some"] : []),
        ...(!hideDmn14BoxedExpressions ? ["filter"] : []),
    ], [hideDmn14BoxedExpressions, isNested]);
    const selectLogicTypeContainer = useRef(null);
    const renderExpression = useMemo(() => {
        const logicType = expression === null || expression === void 0 ? void 0 : expression.__$$element;
        if (!logicType) {
            return _jsx(_Fragment, {});
        }
        switch (logicType) {
            case "literalExpression":
                return _jsx(LiteralExpression, { expression: expression, isNested: isNested });
            case "relation":
                return _jsx(RelationExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId });
            case "context":
                return _jsx(ContextExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId });
            case "decisionTable":
                return (_jsx(DecisionTableExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId }));
            case "list":
                return _jsx(ListExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId });
            case "invocation":
                return _jsx(InvocationExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId });
            case "functionDefinition":
                return _jsx(FunctionExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId });
            case "conditional":
                return _jsx(ConditionalExpression, { expression: expression, isNested: isNested, parentElementId: parentElementId });
            case "for":
            case "every":
            case "some":
                return (_jsx(IteratorExpressionComponent, { expression: expression, isNested: isNested, parentElementId: parentElementId }));
            case "filter":
                return (_jsx(FilterExpressionComponent, { expression: expression, isNested: isNested, parentElementId: parentElementId }));
            default:
                assertUnreachable(logicType);
        }
    }, [expression, isNested, parentElementId]);
    const selectLogicType = useCallback((mouseEvent, itemId) => {
        if (itemId !== PASTE_MENU_ITEM_ID) {
            onLogicTypeSelected(itemId);
        }
        setCurrentlyOpenContextMenu(undefined);
        setVisibleHelp("");
        setOpen(false);
        mouseEvent.stopPropagation();
    }, [onLogicTypeSelected, setCurrentlyOpenContextMenu]);
    const resetLogicType = useCallback(() => {
        setCurrentlyOpenContextMenu(undefined);
        setDropdownOpen(false);
        onLogicTypeReset();
    }, [onLogicTypeReset, setCurrentlyOpenContextMenu]);
    const cssClass = useMemo(() => {
        if (expression) {
            return `logic-type-selector logic-type-selected`;
        }
        else {
            return `logic-type-selector logic-type-not-present`;
        }
    }, [expression]);
    const resetContextMenuContainerRef = React.useRef(null);
    const { xPos: resetContextMenuXPos, yPos: resetContextMenuYPos, isOpen: isResetContextMenuOpen, } = useCustomContextMenuHandler(resetContextMenuContainerRef);
    const shouldRenderResetContextMenu = useMemo(() => {
        return isResetContextMenuOpen && expression && isResetSupported;
    }, [isResetContextMenuOpen, isResetSupported, expression]);
    const selectExpressionMenuContainerRef = React.useRef(null);
    const shouldRenderSelectExpressionContextMenu = useMemo(() => {
        return isOpen && !expression;
    }, [isOpen, expression]);
    const hide = useCallback((e) => {
        if (e.target != selectExpressionMenuContainerRef.current) {
            setOpen(false);
        }
    }, []);
    useEffect(() => {
        if (isOpen) {
            document.addEventListener("click", hide);
        }
        return () => {
            document.removeEventListener("click", hide);
        };
    }, [hide, isOpen]);
    const logicTypeIcon = useCallback((logicType) => {
        switch (logicType) {
            case undefined:
                return ``;
            case "literalExpression":
                return (_jsx("span", { children: _jsx("b", { children: _jsx("i", { children: "FEEL" }) }) }));
            case "context":
                return (_jsx("span", { children: _jsx("b", { children: _jsx("i", { children: `{}` }) }) }));
            case "decisionTable":
                return _jsx(TableIcon, {});
            case "relation":
                return _jsx(TableIcon, {});
            case "functionDefinition":
                return (_jsx("span", { children: _jsx("b", { children: _jsx("i", { children: "f" }) }) }));
            case "invocation":
                return (_jsx("span", { children: _jsx("b", { children: _jsx("i", { children: "f()" }) }) }));
            case "list":
                return _jsx(ListIcon, {});
            case "conditional":
                return (_jsx("span", { children: _jsx("b", { children: _jsx("i", { children: "if" }) }) }));
            case "for":
                return _jsx(RebootingIcon, {});
            case "every":
                return _jsx(ResourcesFullIcon, {});
            case "some":
                return _jsx(ResourcesAlmostEmptyIcon, {});
            case "filter":
                return _jsx(FilterIcon, {});
            default:
                assertUnreachable(logicType);
        }
    }, []);
    const copyExpression = useCallback(() => {
        navigator.clipboard.writeText(JSON.stringify(buildClipboardFromExpression(expression, widthsById)));
        setDropdownOpen(false);
    }, [expression, widthsById]);
    const cutExpression = useCallback(() => {
        navigator.clipboard.writeText(JSON.stringify(buildClipboardFromExpression(expression, widthsById)));
        onLogicTypeReset();
        setDropdownOpen(false);
    }, [expression, onLogicTypeReset, widthsById]);
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const [pasteExpressionError, setPasteExpressionError] = React.useState("");
    const pasteExpression = useCallback(() => __awaiter(this, void 0, void 0, function* () {
        try {
            const clipboard = JSON.parse(yield navigator.clipboard.readText());
            if (clipboard.mimeType !== DMN_BOXED_EXPRESSION_CLIPBOARD_MIME_TYPE) {
                throw new Error("Pasted expression doesn't have the correct mime-type. Likely not copied from the Boxed Expression Editor.");
            }
            const newIdsByOriginalId = mutateExpressionRandomizingIds(clipboard.expression);
            let oldExpression;
            setExpression((prev) => {
                oldExpression = prev;
                return clipboard.expression;
            });
            setWidthsById(({ newMap }) => {
                for (const id of findAllIdsDeep(oldExpression)) {
                    newMap.delete(id);
                }
                for (const originalId in clipboard.widthsById) {
                    newMap.set(newIdsByOriginalId.get(originalId), clipboard.widthsById[originalId]);
                }
            });
            setDropdownOpen(false);
            setCurrentlyOpenContextMenu(undefined);
            setPasteExpressionError("");
        }
        catch (err) {
            setPasteExpressionError(err);
        }
    }), [setCurrentlyOpenContextMenu, setExpression, setWidthsById]);
    const menuIconContainerStyle = useMemo(() => {
        return {
            width: "40px",
            userSelect: "none",
            position: "relative",
        };
    }, []);
    const showExpressionHeader = useMemo(() => {
        if (!expression) {
            return false;
        }
        if (!isNested) {
            return true;
        }
        return expression.__$$element !== "literalExpression" && !nonSelectableLogicTypes.has(expression.__$$element);
    }, [expression, isNested, nonSelectableLogicTypes]);
    const logicTypeHelp = useCallback((logicType) => {
        switch (logicType) {
            case "literalExpression":
                return "A boxed literal expression in DMN is a literal FEEL expression as text in a table cell, typically with a labeled column and an assigned data type.";
            case "context":
                return "A boxed context expression in DMN is a set of variable names and values with a result value. Each name-value pair is a context entry.";
            case "decisionTable":
                return "A decision table in DMN is a visual representation of one or more business rules in a tabular format.";
            case "relation":
                return "A boxed relation expression in DMN is a traditional data table with information about given entities, listed as rows. You use boxed relation tables to define decision data for relevant entities in a decision at a particular node.";
            case "functionDefinition":
                return "A boxed function expression in DMN is a parameterized boxed expression containing a literal FEEL expression, a nested context expression of an external JAVA or PMML function, or a nested boxed expression of any type.";
            case "invocation":
                return "A boxed invocation expression in DMN is a boxed expression that invokes a business knowledge model. A boxed invocation expression contains the name of the business knowledge model to be invoked and a list of parameter bindings.";
            case "list":
                return "A boxed list expression in DMN represents a FEEL list of items. You use boxed lists to define lists of relevant items for a particular node in a decision.";
            case "conditional":
                return 'A boxed conditional offers a visual representation of an if statement using three rows. The expression in the "if" part MUST resolve to a boolean.';
            case "for":
                return ("A boxed iterator offers a visual representation of an iterator statement. " +
                    'For the "for" loop, the right part of the "for" displays the iterator variable name. The second row holds an expression representing the collection that will be iterated over. The expression in the "in" row MUST resolve to a collection.' +
                    " The last row contains the expression that will process each element of the collection.");
            case "every":
                return ("A boxed iterator offers a visual representation of an iterator statement. " +
                    'For the "every" loop, the right part of the "every" displays the iterator variable name. The second row holds an expression representing the collection that will be iterated over. The expression in the "in" row MUST resolve to a collection.' +
                    'The last line is an expression that will be evaluated on each item. The expression defined in the "satisfies" MUST resolve to a boolean.');
            case "some":
                return ("A boxed iterator offers a visual representation of an iterator statement. " +
                    'For the "some" loop, the right part of the "some" displays the iterator variable name. The second row holds an expression representing the collection that will be iterated over. The expression in the "in" row MUST resolve to a collection. ' +
                    'The last line is an expression that will be evaluated on each item. The expression defined in the "satisfies" MUST resolve to a boolean.');
            case "filter":
                return ("A boxed filter offers a visual representation of collection filtering. The top part is an expression that is the collection " +
                    "to be filtered. The bottom part, between the square brackets, holds the filter expression.");
            default:
                return "";
        }
    }, []);
    const contextMenuItems = useMemo(() => {
        return (_jsxs(MenuList, { children: [isResetSupported && (_jsxs(_Fragment, { children: [_jsx(MenuItem, Object.assign({ onClick: resetLogicType, icon: _jsx("div", Object.assign({ style: menuIconContainerStyle }, { children: _jsx(CompressIcon, {}) })) }, { children: i18n.terms.reset })), _jsx(Divider, { style: { padding: "16px", margin: 0 } })] })), _jsx(MenuItem, Object.assign({ onClick: copyExpression, icon: _jsx("div", Object.assign({ style: menuIconContainerStyle }, { children: _jsx(CopyIcon, {}) })) }, { children: i18n.terms.copy })), isResetSupported && (_jsx(MenuItem, Object.assign({ onClick: cutExpression, icon: _jsx("div", Object.assign({ style: menuIconContainerStyle }, { children: _jsx(CutIcon, {}) })) }, { children: i18n.terms.cut }))), _jsx(MenuItem, Object.assign({ className: pasteExpressionError ? "paste-from-clipboard-error" : "", description: pasteExpressionError ? "Paste operation was not successful" : "", onClick: pasteExpression, icon: _jsx("div", Object.assign({ style: menuIconContainerStyle }, { children: _jsx(PasteIcon, {}) })) }, { children: i18n.terms.paste }))] }));
    }, [
        pasteExpressionError,
        copyExpression,
        cutExpression,
        i18n,
        menuIconContainerStyle,
        pasteExpression,
        resetLogicType,
        isResetSupported,
    ]);
    const [isDropdownOpen, setDropdownOpen] = useState(false);
    useEffect(() => {
        if (isResetContextMenuOpen) {
            setDropdownOpen(false);
        }
    }, [isResetContextMenuOpen]);
    const nestedExpressionContainer = useNestedExpressionContainer();
    const [visibleHelp, setVisibleHelp] = React.useState("");
    const toggleVisibleHelp = useCallback((help) => {
        setVisibleHelp((previousHelp) => (previousHelp !== help ? help : ""));
    }, []);
    useLayoutEffect(() => {
        var _a;
        if (selectLogicTypeContainer.current) {
            const boundingClientRect = (_a = selectLogicTypeContainer.current) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect();
            if (boundingClientRect) {
                const yPos = boundingClientRect.top;
                const availableHeight = document.documentElement.clientHeight;
                if (DEFAULT_LOGIC_TYPE_SELECTOR_HEIGHT + yPos > availableHeight) {
                    const offset = DEFAULT_LOGIC_TYPE_SELECTOR_HEIGHT + yPos - availableHeight - LOGIC_TYPE_SELECTOR_BOTTOM_MARGIN;
                    selectLogicTypeContainer.current.style.height = DEFAULT_LOGIC_TYPE_SELECTOR_HEIGHT - offset + "px";
                    selectLogicTypeContainer.current.style.overflowY = "scroll";
                }
                else {
                    selectLogicTypeContainer.current.style.height = DEFAULT_LOGIC_TYPE_SELECTOR_HEIGHT + "px";
                    selectLogicTypeContainer.current.style.overflowY = "visible";
                }
            }
            else {
                selectLogicTypeContainer.current.style.height = DEFAULT_LOGIC_TYPE_SELECTOR_HEIGHT + "px";
                selectLogicTypeContainer.current.style.overflowY = "visible";
            }
        }
    });
    const getRenderExpressionElement = useCallback(() => {
        return (_jsxs(_Fragment, { children: [showExpressionHeader && expression && (_jsx("div", Object.assign({ className: "logic-type-selected-header" }, { children: _jsx(Dropdown, Object.assign({ "data-testid": "logic-type-selected-header", isPlain: true, isOpen: isDropdownOpen, onKeyDown: (e) => {
                            if (NavigationKeysUtils.isEsc(e.key)) {
                                setDropdownOpen(false);
                            }
                        }, toggle: _jsxs(DropdownToggle, Object.assign({ "data-testid": "logic-type-button-test-id", icon: _jsx(_Fragment, { children: logicTypeIcon(expression.__$$element) }), style: { padding: 0 }, onToggle: setDropdownOpen, tabIndex: -1 }, { children: [getLogicTypeLabel(expression === null || expression === void 0 ? void 0 : expression.__$$element), expression.__$$element === "functionDefinition" && ` (${expression["@_kind"]})`] })) }, { children: _jsx(Menu, Object.assign({ className: "table-context-menu", style: { width: "200px", fontSize: "larger" } }, { children: _jsx(_Fragment, { children: contextMenuItems }) })) })) }))), renderExpression] }));
    }, [contextMenuItems, expression, isDropdownOpen, logicTypeIcon, renderExpression, showExpressionHeader]);
    const getSelectExpressionElement = useCallback(() => {
        return (_jsx("div", Object.assign({ className: "context-menu-container", style: {
                top: position.y,
                left: position.x,
                opacity: 1,
                width: "200px",
            }, ref: selectLogicTypeContainer }, { children: _jsx(Menu, Object.assign({ onSelect: selectLogicType }, { children: _jsx(MenuGroup, Object.assign({ className: "menu-with-help", style: { paddingBottom: "16px" } }, { children: _jsxs(MenuList, { children: [selectableLogicTypes.map((key) => {
                                const label = getLogicTypeLabel(key);
                                return (_jsx(MenuItemWithHelp, { menuItemKey: key, menuItemHelp: logicTypeHelp(key), menuItemIcon: logicTypeIcon(key), menuItemCustomText: label, menuItemIconStyle: menuIconContainerStyle, setVisibleHelp: toggleVisibleHelp, visibleHelp: visibleHelp }, key));
                            }), _jsx(Divider, { style: { padding: "16px" } }), _jsx(MenuItem, Object.assign({ itemId: PASTE_MENU_ITEM_ID, className: pasteExpressionError ? "paste-from-clipboard-error" : "", description: pasteExpressionError ? "Paste operation was not successful" : "", onClick: pasteExpression, icon: _jsx("div", Object.assign({ style: menuIconContainerStyle }, { children: _jsx(PasteIcon, {}) })) }, { children: i18n.terms.paste }))] }) })) })) })));
    }, [
        i18n.terms.paste,
        logicTypeHelp,
        logicTypeIcon,
        menuIconContainerStyle,
        pasteExpression,
        pasteExpressionError,
        position.x,
        position.y,
        selectLogicType,
        selectableLogicTypes,
        toggleVisibleHelp,
        visibleHelp,
    ]);
    const getResetExpressionElement = useCallback(() => {
        return (_jsx("div", Object.assign({ className: "context-menu-container", style: {
                top: resetContextMenuYPos,
                left: resetContextMenuXPos,
                opacity: 1,
                minWidth: "150px",
            }, onKeyDown: (e) => {
                if (NavigationKeysUtils.isEsc(e.key)) {
                    setDropdownOpen(false);
                }
            } }, { children: _jsxs(Menu, Object.assign({ className: "table-context-menu" }, { children: [_jsx(MenuGroup, { label: `${getLogicTypeLabel(expression === null || expression === void 0 ? void 0 : expression.__$$element).toLocaleUpperCase()} EXPRESSION` }), contextMenuItems] })) })));
    }, [contextMenuItems, expression === null || expression === void 0 ? void 0 : expression.__$$element, resetContextMenuXPos, resetContextMenuYPos]);
    return (_jsxs(_Fragment, { children: [!expression && (_jsxs("div", Object.assign({ className: cssClass, ref: selectExpressionMenuContainerRef, onClick: showSelectExpression, style: !expression && nestedExpressionContainer.resizingWidth
                    ? { width: `${(_a = nestedExpressionContainer.resizingWidth) === null || _a === void 0 ? void 0 : _a.value}px` }
                    : {} }, { children: [i18n.selectExpression, !expression && shouldRenderSelectExpressionContextMenu && getSelectExpressionElement()] }))), expression && (_jsx("div", Object.assign({ className: cssClass, ref: resetContextMenuContainerRef, style: !expression && nestedExpressionContainer.resizingWidth
                    ? { width: `${(_b = nestedExpressionContainer.resizingWidth) === null || _b === void 0 ? void 0 : _b.value}px` }
                    : {} }, { children: expression ? getRenderExpressionElement() : i18n.selectExpression }))), shouldRenderResetContextMenu && getResetExpressionElement()] }));
}
export function assertUnreachable(_x) {
    throw new Error("Didn't expect to get here: " + _x);
}
function getLogicTypeLabel(logicType) {
    switch (logicType) {
        case undefined:
            return "Undefined";
        case "context":
            return "Context";
        case "literalExpression":
            return "Literal";
        case "relation":
            return "Relation";
        case "decisionTable":
            return "Decision table";
        case "list":
            return "List";
        case "invocation":
            return "Invocation";
        case "functionDefinition":
            return "Function";
        case "for":
            return "For";
        case "every":
            return "Every";
        case "some":
            return "Some";
        case "conditional":
            return "Conditional";
        case "filter":
            return "Filter";
    }
}
//# sourceMappingURL=ExpressionDefinitionLogicTypeSelector.js.map