import "@patternfly/react-styles/css/components/Drawer/drawer.css";
import * as React from "react";
import { BeeGwtService, BoxedExpression, DmnDataType, PmmlDocument } from "./api";
import { FeelVariables } from "@kie-tools/dmn-feel-antlr4-parser";
import "./base-no-reset-wrapped.css";
import "./@types/react-table";
export declare type OnRequestFeelVariables = () => FeelVariables;
export interface BoxedExpressionEditorProps {
    beeGwtService?: BeeGwtService;
    expressionHolderId: string;
    expressionHolderName: string;
    expressionHolderTypeRef: string | undefined;
    expression: BoxedExpression | undefined;
    onExpressionChange: React.Dispatch<React.SetStateAction<BoxedExpression | undefined>>;
    widthsById: Map<string, number[]>;
    onWidthsChange: React.Dispatch<React.SetStateAction<Map<string, number[]>>>;
    isResetSupportedOnRootExpression?: boolean;
    dataTypes: DmnDataType[];
    pmmlDocuments?: PmmlDocument[];
    scrollableParentRef: React.RefObject<HTMLElement>;
    onRequestFeelVariables?: OnRequestFeelVariables;
    hideDmn14BoxedExpressions?: boolean;
}
export declare function BoxedExpressionEditor({ dataTypes, expressionHolderId, expressionHolderName, expressionHolderTypeRef, expression, onExpressionChange, beeGwtService, isResetSupportedOnRootExpression, scrollableParentRef, pmmlDocuments, onRequestFeelVariables, widthsById, onWidthsChange, hideDmn14BoxedExpressions, }: BoxedExpressionEditorProps): JSX.Element;
//# sourceMappingURL=BoxedExpressionEditor.d.ts.map