import { CapabilityChannelApi } from "@kie-tools-core/backend/dist/channel-api";
import { NotificationsChannelApi } from "@kie-tools-core/notifications/dist/api";
import { I18nChannelApi } from "@kie-tools-core/i18n/dist/api";
import { WorkspaceChannelApi } from "@kie-tools-core/workspace/dist/api";
import { EditorContent } from "./EditorContent";
import { StateControlCommand } from "./StateControlCommand";
import { EditorTheme } from "./EditorTheme";
import { SharedValueProvider } from "@kie-tools-core/envelope-bus/dist/api";
export interface KogitoEditorChannelApi extends I18nChannelApi, CapabilityChannelApi, WorkspaceChannelApi, NotificationsChannelApi {
    kogitoEditor_ready(): void;
    kogitoEditor_setContentError(content: EditorContent): void;
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoEditor_contentRequest(): Promise<EditorContent>;
    kogitoEditor_theme(): SharedValueProvider<EditorTheme>;
}
//# sourceMappingURL=KogitoEditorChannelApi.d.ts.map