import { Notification } from "@kie-tools-core/notifications/dist/api";
import { EditorTheme } from "./EditorTheme";
export interface Editor extends EditorApi {
    af_isReact: boolean;
    af_componentId: string;
    af_componentTitle: string;
    af_componentRoot(): React.ReactPortal | React.ReactElement | HTMLElement | string;
    af_onStartup?(): void;
    af_onOpen?(): void;
}
export interface EditorApi {
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    getContent(): Promise<string>;
    getPreview(): Promise<string | undefined>;
    undo(): Promise<void>;
    redo(): Promise<void>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
}
//# sourceMappingURL=Editor.d.ts.map