"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOperatingSystem = exports.OperatingSystem = void 0;
var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["MACOS"] = "MACOS";
    OperatingSystem["WINDOWS"] = "WINDOWS";
    OperatingSystem["LINUX"] = "LINUX";
})(OperatingSystem = exports.OperatingSystem || (exports.OperatingSystem = {}));
function getOperatingSystem() {
    if (navigator.appVersion.indexOf("Win") !== -1) {
        return OperatingSystem.WINDOWS;
    }
    if (navigator.appVersion.indexOf("Mac") !== -1) {
        return OperatingSystem.MACOS;
    }
    if (navigator.appVersion.indexOf("X11") !== -1) {
        return OperatingSystem.LINUX;
    }
    if (navigator.appVersion.indexOf("Linux") !== -1) {
        return OperatingSystem.LINUX;
    }
    return undefined;
}
exports.getOperatingSystem = getOperatingSystem;
//# sourceMappingURL=OperatingSystem.js.map