import React from "react";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
export const setTitle = (titleStatus, titleText) => {
    let icon;
    switch (titleStatus) {
        case "success":
            icon = React.createElement(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--info-color--100)" });
            break;
        case "failure":
            icon = React.createElement(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" });
            break;
    }
    return (React.createElement(Title, { headingLevel: "h1", size: TitleSizes["2xl"] },
        icon,
        React.createElement("span", null, titleText)));
};
export const constructObject = (obj, path, val) => {
    const keys = path.split(",");
    const lastKey = keys.pop();
    const lastObj = keys.reduce((_obj, key) => (_obj[key] = obj[key] || {}), obj);
    lastObj[lastKey] = val;
};
//# sourceMappingURL=Utils.js.map