import React from "react";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Badge } from "@patternfly/react-core/dist/js/components/Badge";
import { componentOuiaProps } from "../../ouiaTools";
export const ItemDescriptor = ({ itemDescription, ouiaId, ouiaSafe }) => {
    const tooltipContainerId = `kogito-consoles-tooltip-${itemDescription.id}-${Math.random()}`;
    const idStringModifier = (strId) => {
        return (React.createElement(TextContent, { className: "pf-u-display-inline" },
            React.createElement(Text, { component: TextVariants.small, className: "pf-u-display-inline" }, strId.substring(0, 5))));
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(Tooltip, Object.assign({ appendTo: () => document.getElementById(tooltipContainerId), content: itemDescription.id }, componentOuiaProps(ouiaId, "item-descriptor", ouiaSafe)),
            React.createElement("span", null,
                itemDescription.name,
                " ",
                itemDescription.description ? (React.createElement(Badge, null, itemDescription.description)) : (idStringModifier(itemDescription.id)))),
        React.createElement("div", { id: tooltipContainerId })));
};
//# sourceMappingURL=ItemDescriptor.js.map