import React from "react";
import _ from "lodash";
import { ActionList, ActionListItem } from "@patternfly/react-core/dist/js/components/ActionList";
import { convertActionsToButton } from "../../utils";
import { componentOuiaProps } from "../../ouiaTools";
import "../styles.css";
export const FormFooter = ({ actions, enabled = true, onSubmitForm, ouiaId, ouiaSafe, }) => {
    var _a;
    if (_.isEmpty(actions)) {
        return null;
    }
    const actionItems = (_a = convertActionsToButton(actions, enabled, onSubmitForm)) === null || _a === void 0 ? void 0 : _a.map((button, index) => {
        return (React.createElement(ActionListItem, { key: `form-action-${index}`, "data-testid": "action-list-item" }, button));
    });
    return (React.createElement("div", Object.assign({ className: "kogito-components-common__form-footer-padding-top" }, componentOuiaProps(ouiaId, "form-footer", ouiaSafe)),
        React.createElement(ActionList, { "data-testid": "action-list" }, actionItems)));
};
//# sourceMappingURL=FormFooter.js.map