import { SelectDirection } from "@patternfly/react-core/dist/js/components/Select";
import { JSONSchemaBridge } from "uniforms-bridge-json-schema";
import { joinName } from "uniforms";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
export const DEFAULT_COLUMN_MIN_WIDTH = 150;
const DEFAULT_DATE_TIME_CELL_WDITH = 210;
const DEFAULT_DATE_CELL_WIDTH = 170;
const DEFAULT_TIME_CELL_WIDTH = 150;
const DEFAULT_DAYS_DURATION_CELL_WIDTH = 245;
const DEFAULT_YEARS_DURATION_CELL_WIDTH = 180;
export const FORMS_ID = "unitables-forms";
export const AUTO_ROW_ID = "unitables-row";
export class UnitablesJsonSchemaBridge extends JSONSchemaBridge {
    constructor(formSchema, validator, i18n) {
        super(formSchema, validator);
        this.formSchema = formSchema;
        this.validator = validator;
        this.i18n = i18n;
    }
    getProps(name, props = {}) {
        const finalProps = super.getProps(name, props);
        finalProps.label = "";
        finalProps.style = Object.assign(Object.assign({}, finalProps.style), { height: "100%" });
        if (finalProps.required) {
            finalProps.required = false;
        }
        return finalProps;
    }
    getField(name) {
        const field = super.getField(name);
        if ((field.type === "string" || field.type === "number") && field.enum) {
            field.placeholder = this.i18n.schema.selectPlaceholder;
            field.direction = SelectDirection.up;
            field.menuAppendTo = document.body;
        }
        else if (!field.type) {
            field.type = "string";
        }
        if (field.type === "string" || field.type === "number") {
            field.style = { width: "100%" };
        }
        field.style = Object.assign(Object.assign({}, field.style), { minWidth: this.getFieldDataType(field).width });
        return field;
    }
    getFieldDataType(field) {
        var _a, _b, _c, _d, _e, _f;
        const xDmnType = field["x-dmn-type"];
        let type;
        if (!xDmnType) {
            type = field.type;
        }
        else {
            if (((_a = field.format) === null || _a === void 0 ? void 0 : _a.includes("date")) || ((_b = field.format) === null || _b === void 0 ? void 0 : _b.includes("time")) || ((_c = field.format) === null || _c === void 0 ? void 0 : _c.includes("duration"))) {
                type = field.format;
            }
            else {
                const splitedXDmnType = xDmnType.split(":");
                if (!splitedXDmnType) {
                    type = undefined;
                }
                else if (splitedXDmnType.length > 2) {
                    type = (_e = (_d = splitedXDmnType[2].split("}")) === null || _d === void 0 ? void 0 : _d[0]) === null || _e === void 0 ? void 0 : _e.trim();
                }
                else if (splitedXDmnType.length === 2) {
                    type = splitedXDmnType[1];
                }
                else {
                    type = splitedXDmnType[0];
                }
            }
        }
        switch (type) {
            case "<Undefined>":
                return {
                    dataType: DmnBuiltInDataType.Undefined,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
            case "Any":
                return {
                    dataType: DmnBuiltInDataType.Any,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
            case "boolean":
                return {
                    dataType: DmnBuiltInDataType.Boolean,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
            case "context":
                return {
                    dataType: DmnBuiltInDataType.Context,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
            case "date":
                return {
                    dataType: DmnBuiltInDataType.Date,
                    width: DEFAULT_DATE_CELL_WIDTH,
                    type: field.type,
                };
            case "date-time":
            case "date and time":
                return {
                    dataType: DmnBuiltInDataType.DateTime,
                    width: DEFAULT_DATE_TIME_CELL_WDITH,
                    type: field.type,
                };
            case "days and time duration":
                return {
                    dataType: DmnBuiltInDataType.DateTimeDuration,
                    width: DEFAULT_DAYS_DURATION_CELL_WIDTH,
                    type: field.type,
                };
            case "number":
                return {
                    dataType: DmnBuiltInDataType.Number,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
            case "string":
                return {
                    dataType: DmnBuiltInDataType.String,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
            case "time":
                return {
                    dataType: DmnBuiltInDataType.Time,
                    width: DEFAULT_TIME_CELL_WIDTH,
                    type: field.type,
                };
            case "years and months duration":
                return {
                    dataType: DmnBuiltInDataType.YearsMonthsDuration,
                    width: DEFAULT_YEARS_DURATION_CELL_WIDTH,
                    type: field.type,
                };
            default:
                if (field.type === "array") {
                    const itemsType = this.getFieldDataType(field.items);
                    return {
                        dataType: `List<${itemsType.dataType}>`,
                        width: DEFAULT_COLUMN_MIN_WIDTH,
                        type: field.type,
                    };
                }
                return {
                    dataType: (_f = type) !== null && _f !== void 0 ? _f : DmnBuiltInDataType.Undefined,
                    width: DEFAULT_COLUMN_MIN_WIDTH,
                    type: field.type,
                };
        }
    }
    deepTransformToUnitablesColumns(fieldName, parentName = "") {
        const joinedName = joinName(parentName, fieldName);
        const field = this.getField(joinedName);
        if (field.type !== "object") {
            return Object.assign(Object.assign({}, this.getFieldDataType(field)), { name: removeFieldName(joinedName), joinedName: joinedName });
        }
        const insideProperties = this.getSubfields(joinedName).reduce((insideProperties, subField) => {
            const field = this.deepTransformToUnitablesColumns(subField, joinedName);
            if (field.insideProperties) {
                return [...insideProperties, ...field.insideProperties];
            }
            else {
                return [...insideProperties, field];
            }
        }, []);
        return Object.assign(Object.assign({}, this.getFieldDataType(field)), { insideProperties, name: joinedName, joinedName: joinedName, width: insideProperties.reduce((acc, insideProperty) => { var _a; return acc + ((_a = insideProperty.width) !== null && _a !== void 0 ? _a : 0); }, 0) });
    }
    getUnitablesColumns() {
        var _a;
        return ((_a = super.getSubfields()) !== null && _a !== void 0 ? _a : []).reduce((fields, fieldName) => {
            const generateInputFields = this.deepTransformToUnitablesColumns(fieldName);
            if (generateInputFields) {
                return [...fields, generateInputFields];
            }
            else {
                return fields;
            }
        }, []);
    }
}
function removeFieldName(fullName) {
    return fullName.match(/\./) ? fullName.split(".").slice(1).join("-") : fullName;
}
//# sourceMappingURL=UnitablesJsonSchemaBridge.js.map