"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportVectorMachineModelFactory = exports.SUPPORT_VECTOR_MACHINE_MODEL = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelExplanation_1 = require("./ModelExplanation");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
var Targets_1 = require("./Targets");
exports.SUPPORT_VECTOR_MACHINE_MODEL = "\nelements.elements[(name = \"SupportVectorMachineModel\")] ~> $map(function($v, $i) {\n  $merge([\n    $supportVectorMachineModelFactory(),\n    $v.attributes,\n    {\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(Output_1.OUTPUT, ",\n      ").concat(ModelStats_1.MODEL_STATS, ",\n      ").concat(ModelExplanation_1.MODEL_EXPLANATION, ",\n      ").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n      ").concat(Targets_1.TARGETS, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, "\n    }\n  ])\n})");
function supportVectorMachineModelFactory() {
    return new pmml4_4_1.SupportVectorMachineModel({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        SupportVectorMachine: [],
        VectorDictionary: { VectorFields: {} },
        functionName: "regression",
    });
}
exports.supportVectorMachineModelFactory = supportVectorMachineModelFactory;
//# sourceMappingURL=SupportVectorMachineModel.js.map