"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LfsFsCache = void 0;
var kie_sandbox_fs_1 = __importDefault(require("@kie-tools/kie-sandbox-fs"));
var DefaultBackend_1 = __importDefault(require("@kie-tools/kie-sandbox-fs/dist/DefaultBackend"));
var DexieBackend_1 = __importDefault(require("@kie-tools/kie-sandbox-fs/dist/DexieBackend"));
var LfsFsCache = (function () {
    function LfsFsCache() {
        this.fsCache = new Map();
    }
    LfsFsCache.prototype.getOrCreateFs = function (fsMountPoint) {
        var fs = this.fsCache.get(fsMountPoint);
        if (fs) {
            return fs;
        }
        var newFs = new kie_sandbox_fs_1.default(fsMountPoint, {
            backend: new DefaultBackend_1.default({
                idbBackendDelegate: function (fileDbName, fileStoreName) { return new DexieBackend_1.default(fileDbName, fileStoreName); },
            }),
        });
        this.fsCache.set(fsMountPoint, newFs);
        return newFs;
    };
    return LfsFsCache;
}());
exports.LfsFsCache = LfsFsCache;
//# sourceMappingURL=LfsFsCache.js.map