var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { ContentField, DescriptionField, ExpressionLanguageField, NameField, TypeRefField } from "./Fields";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { PropertiesPanelHeader } from "../PropertiesPanelHeader";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useDmnEditor } from "../../DmnEditorContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function DecisionTableOutputHeaderCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    var defaultOutputEntry = useMemo(function () { return cell.defaultOutputEntry; }, [cell.defaultOutputEntry]);
    var outputValues = useMemo(function () { return cell.outputValues; }, [cell.outputValues]);
    var itemDefinition = useMemo(function () {
        var _a, _b, _c;
        var _d = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace), allDataTypesById = _d.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _d.allTopLevelItemDefinitionUniqueNames;
        return (_c = allDataTypesById.get((_b = allTopLevelItemDefinitionUniqueNames.get((_a = cell === null || cell === void 0 ? void 0 : cell["@_typeRef"]) !== null && _a !== void 0 ? _a : "")) !== null && _b !== void 0 ? _b : "")) === null || _c === void 0 ? void 0 : _c.itemDefinition;
    }, [cell, dmnEditorStoreApi, externalModelsByNamespace]);
    var root = useMemo(function () {
        var _a, _b, _c, _d;
        return (_d = (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get((_c = (_b = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 1]) === null || _b === void 0 ? void 0 : _b.root) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.cell;
    }, [props.boxedExpressionIndex, selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    var _y = __read(useState(false), 2), isDefaultOutputEntryExpanded = _y[0], setDefaultOutputEntryExpanded = _y[1];
    var _z = __read(useState(false), 2), isOutputValuesExpanded = _z[0], setOutputValuesExpanded = _z[1];
    var getAllUniqueNames = useCallback(function (s) { return new Map(); }, []);
    var alternativeFieldName = useMemo(function () {
        if ((selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) === 1) {
            return "Decision";
        }
        var parentType = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[(selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath.length) - 2].type;
        switch (parentType) {
            case "context":
                return "Entry";
            case "functionDefinition":
                return "Function";
            case "invocation":
                return "Parameter";
            case "list":
                return "Item";
            case "conditional":
            case "every":
            case "filter":
            case "for":
            case "some":
            default:
                return "Expression";
        }
    }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath]);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: selectedObjectId })) })), (root === null || root === void 0 ? void 0 : root.output.length) === 1 && (_jsxs(_Fragment, { children: [_jsx(NameField, { alternativeFieldName: "".concat(alternativeFieldName, " Name"), isReadonly: true, id: root["@_id"], name: (_b = root === null || root === void 0 ? void 0 : root["@_label"]) !== null && _b !== void 0 ? _b : "", getAllUniqueNames: getAllUniqueNames }), _jsx(TypeRefField, { alternativeFieldName: "".concat(alternativeFieldName, " Type"), isReadonly: true, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: root === null || root === void 0 ? void 0 : root["@_typeRef"] })] })), _jsx(NameField, { alternativeFieldName: (root === null || root === void 0 ? void 0 : root.output.length) === 1 ? "Column Name" : undefined, isReadonly: props.isReadonly, id: cell["@_id"], name: (_c = cell === null || cell === void 0 ? void 0 : cell["@_name"]) !== null && _c !== void 0 ? _c : "", getAllUniqueNames: getAllUniqueNames, onChange: function (newName) {
                    return updater(function (dmnObject) {
                        dmnObject["@_name"] = newName;
                    });
                } }), _jsx(TypeRefField, { alternativeFieldName: (root === null || root === void 0 ? void 0 : root.output.length) === 1 ? "Column Type" : undefined, isReadonly: props.isReadonly, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: cell === null || cell === void 0 ? void 0 : cell["@_typeRef"], onChange: function (newTypeRef) {
                    return updater(function (dmnObject) {
                        dmnObject["@_typeRef"] = newTypeRef;
                    });
                } }), itemDefinition && (_jsx(FormGroup, __assign({ label: "Constraint" }, { children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: true, itemDefinition: itemDefinition, editItemDefinition: function () { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) }))), _jsx(DescriptionField, { isReadonly: props.isReadonly, expressionPath: (_d = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _d !== void 0 ? _d : [], initialValue: (_f = (_e = cell === null || cell === void 0 ? void 0 : cell.description) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : "", onChange: function (newDescription) {
                    return updater(function (dmnObject) {
                        var _a;
                        (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                        dmnObject.description.__$$text = newDescription;
                    });
                } }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isDefaultOutputEntryExpanded, toogleSectionExpanded: function () { return setDefaultOutputEntryExpanded(function (prev) { return !prev; }); }, title: "Default Output Entry" }), isDefaultOutputEntryExpanded && (_jsxs(_Fragment, { children: [_jsx(ExpressionLanguageField, { isReadonly: props.isReadonly, initialValue: (_g = defaultOutputEntry === null || defaultOutputEntry === void 0 ? void 0 : defaultOutputEntry["@_expressionLanguage"]) !== null && _g !== void 0 ? _g : "", expressionPath: (_h = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _h !== void 0 ? _h : [], onChange: function (newExpressionLanguage) {
                                    return updater(function (dmnObject) {
                                        var _a;
                                        (_a = dmnObject.defaultOutputEntry) !== null && _a !== void 0 ? _a : (dmnObject.defaultOutputEntry = { "@_id": generateUuid() });
                                        dmnObject.defaultOutputEntry["@_expressionLanguage"] = newExpressionLanguage;
                                    });
                                } }), _jsx(ContentField, { isReadonly: props.isReadonly, initialValue: (_k = (_j = defaultOutputEntry === null || defaultOutputEntry === void 0 ? void 0 : defaultOutputEntry.text) === null || _j === void 0 ? void 0 : _j.__$$text) !== null && _k !== void 0 ? _k : "", expressionPath: (_l = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _l !== void 0 ? _l : [], onChange: function (newText) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.defaultOutputEntry) !== null && _a !== void 0 ? _a : (dmnObject.defaultOutputEntry = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        (_b = (_c = dmnObject.defaultOutputEntry).text) !== null && _b !== void 0 ? _b : (_c.text = { __$$text: "" });
                                        dmnObject.defaultOutputEntry.text.__$$text = newText;
                                    });
                                } }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_o = (_m = defaultOutputEntry === null || defaultOutputEntry === void 0 ? void 0 : defaultOutputEntry.description) === null || _m === void 0 ? void 0 : _m.__$$text) !== null && _o !== void 0 ? _o : "", expressionPath: (_p = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _p !== void 0 ? _p : [], onChange: function (newDescription) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.defaultOutputEntry) !== null && _a !== void 0 ? _a : (dmnObject.defaultOutputEntry = { "@_id": generateUuid(), description: { __$$text: "" } });
                                        (_b = (_c = dmnObject.defaultOutputEntry).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                        dmnObject.defaultOutputEntry.description.__$$text = newDescription;
                                    });
                                } })] }))] }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isOutputValuesExpanded, toogleSectionExpanded: function () { return setOutputValuesExpanded(function (prev) { return !prev; }); }, title: "Output Values" }), isOutputValuesExpanded && (_jsxs(_Fragment, { children: [_jsx(ExpressionLanguageField, { isReadonly: props.isReadonly, initialValue: (_q = outputValues === null || outputValues === void 0 ? void 0 : outputValues["@_expressionLanguage"]) !== null && _q !== void 0 ? _q : "", expressionPath: (_r = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _r !== void 0 ? _r : [], onChange: function (newExpressionLanguage) {
                                    return updater(function (dmnObject) {
                                        var _a;
                                        (_a = dmnObject.outputValues) !== null && _a !== void 0 ? _a : (dmnObject.outputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        dmnObject.outputValues["@_expressionLanguage"] = newExpressionLanguage;
                                    });
                                } }), _jsx(ContentField, { isReadonly: props.isReadonly, initialValue: (_t = (_s = outputValues === null || outputValues === void 0 ? void 0 : outputValues.text) === null || _s === void 0 ? void 0 : _s.__$$text) !== null && _t !== void 0 ? _t : "", expressionPath: (_u = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _u !== void 0 ? _u : [], onChange: function (newText) {
                                    return updater(function (dmnObject) {
                                        var _a;
                                        (_a = dmnObject.outputValues) !== null && _a !== void 0 ? _a : (dmnObject.outputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        dmnObject.outputValues.text.__$$text = newText;
                                    });
                                } }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_w = (_v = outputValues === null || outputValues === void 0 ? void 0 : outputValues.description) === null || _v === void 0 ? void 0 : _v.__$$text) !== null && _w !== void 0 ? _w : "", expressionPath: (_x = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _x !== void 0 ? _x : [], onChange: function (newDescription) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.outputValues) !== null && _a !== void 0 ? _a : (dmnObject.outputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        (_b = (_c = dmnObject.outputValues).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                        dmnObject.outputValues.description.__$$text = newDescription;
                                    });
                                } })] }))] })] }));
}
//# sourceMappingURL=DecisionTableOutputHeaderCell.js.map