var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DrawerActions, DrawerCloseButton, DrawerHead, DrawerPanelContent, } from "@patternfly/react-core/dist/js/components/Drawer";
import { useMemo } from "react";
import { buildXmlHref } from "../xml/xmlHrefs";
import { SingleNodeProperties } from "./SingleNodeProperties";
import { generateBoxedExpressionIndex } from "../boxedExpressions/boxedExpressionIndex";
import { Form, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { RelationInformationItemCell } from "./BoxedExpressionPropertiesPanelComponents/RelationInformationItemCell";
import { DecisionTableInputHeaderCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableInputHeaderCell";
import { DecisionTableOutputHeaderCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableOutputHeaderCell";
import { LiteralExpressionContentCell } from "./BoxedExpressionPropertiesPanelComponents/LiteralExpressionContentCell";
import { ExpressionRootCell } from "./BoxedExpressionPropertiesPanelComponents/ExpressionRootCell";
import { DecisionTableInputRule } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableInputRuleCell";
import { DecisionTableRootCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableRootCell";
import { InvocationFunctionCallCell } from "./BoxedExpressionPropertiesPanelComponents/InvocationFunctionCallCell";
import { FunctionDefinitionParameterCell } from "./BoxedExpressionPropertiesPanelComponents/FunctionDefinitionParametersCell";
import { FunctionDefinitionRootCell } from "./BoxedExpressionPropertiesPanelComponents/FunctionDefinitionRootCell";
import { WithoutPropertiesCell } from "./BoxedExpressionPropertiesPanelComponents/WithoutPropertiesCell";
import { DecisionTableOutputRuleCell } from "./BoxedExpressionPropertiesPanelComponents/DecisionTableOutputRuleCell";
import { ContextInformationItemCell } from "./BoxedExpressionPropertiesPanelComponents/ContextInformationItemCell";
import { InvocationInformationItemCell } from "./BoxedExpressionPropertiesPanelComponents/InvocationInformationItemCell";
import { SelectExpressionCell } from "./BoxedExpressionPropertiesPanelComponents/SelectExpressionCell";
import { BoxedExpressionPropertiesPanelComponent, getBoxedExpressionPropertiesPanelComponent, } from "./BoxedExpressionPropertiesPanelComponents/getBoxedExpressionPropertiesPanelComponent";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { drgElementToBoxedExpression } from "../boxedExpressions/BoxedExpressionScreen";
import { IteratorVariableCell } from "./BoxedExpressionPropertiesPanelComponents/IteratorVariableCell";
export function BoxedExpressionPropertiesPanel() {
    var _a;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var activeDrgElementId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.activeDrgElementId; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var shouldDisplayDecisionOrBkmProps = useMemo(function () { return selectedObjectId === undefined || (selectedObjectId && selectedObjectId === activeDrgElementId); }, [activeDrgElementId, selectedObjectId]);
    var node = useDmnEditorStore(function (s) {
        return s
            .computed(s)
            .getDiagramData(externalModelsByNamespace)
            .nodesById.get(buildXmlHref({ id: activeDrgElementId !== null && activeDrgElementId !== void 0 ? activeDrgElementId : "" }));
    });
    var isReadonly = !!(node === null || node === void 0 ? void 0 : node.data.dmnObjectNamespace) && node.data.dmnObjectNamespace !== thisDmnsNamespace;
    var boxedExpressionIndex = useMemo(function () {
        var _a, _b;
        if ((node === null || node === void 0 ? void 0 : node.data.dmnObject) === undefined) {
            return;
        }
        if (((_a = node.data.dmnObject) === null || _a === void 0 ? void 0 : _a.__$$element) === "businessKnowledgeModel" ||
            ((_b = node.data.dmnObject) === null || _b === void 0 ? void 0 : _b.__$$element) === "decision") {
            var expression = drgElementToBoxedExpression(node.data.dmnObject);
            return expression ? generateBoxedExpressionIndex(expression, new Map(), []) : undefined;
        }
        return;
    }, [node === null || node === void 0 ? void 0 : node.data.dmnObject]);
    var boxedExpressionPropertiesPanelComponent = useMemo(function () {
        var selectedObjectInfos = boxedExpressionIndex === null || boxedExpressionIndex === void 0 ? void 0 : boxedExpressionIndex.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : "");
        var selectedObjectPath = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath[selectedObjectInfos.expressionPath.length - 1];
        if (!selectedObjectPath) {
            return;
        }
        return getBoxedExpressionPropertiesPanelComponent(selectedObjectPath);
    }, [boxedExpressionIndex, selectedObjectId]);
    return (_jsx(_Fragment, { children: node && (_jsx(DrawerPanelContent, __assign({ isResizable: true, minSize: "300px", defaultSize: "500px", onKeyDown: function (e) { return e.stopPropagation(); } }, { children: _jsxs(DrawerHead, { children: [shouldDisplayDecisionOrBkmProps && _jsx(SingleNodeProperties, { nodeId: node.id }), _jsx(DrawerActions, { children: _jsx(DrawerCloseButton, { onClick: function () {
                                dmnEditorStoreApi.setState(function (state) {
                                    state.boxedExpressionEditor.propertiesPanel.isOpen = false;
                                });
                            } }) }), !shouldDisplayDecisionOrBkmProps && (_jsx(Form, { children: _jsxs(FormSection, __assign({ title: (_a = boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.title) !== null && _a !== void 0 ? _a : "" }, { children: [(((selectedObjectId === undefined || selectedObjectId === "") &&
                                    boxedExpressionPropertiesPanelComponent === undefined) ||
                                    (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                        BoxedExpressionPropertiesPanelComponent.WITHOUT_PROPERTIES_CELL) && _jsx(WithoutPropertiesCell, {}), selectedObjectId !== "" && boxedExpressionPropertiesPanelComponent === undefined && (_jsx(SelectExpressionCell, { selectedObjectId: selectedObjectId })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.CONTEXT_INFORMATION_ITEM_CELL && (_jsx(ContextInformationItemCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_INPUT_HEADER && (_jsx(DecisionTableInputHeaderCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_INPUT_RULE && (_jsx(DecisionTableInputRule, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_OUTPUT_HEADER && (_jsx(DecisionTableOutputHeaderCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_OUTPUT_RULE && (_jsx(DecisionTableOutputRuleCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.DECISION_TABLE_ROOT && (_jsx(DecisionTableRootCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.EXPRESSION_ROOT && (_jsx(ExpressionRootCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.FUNCTION_DEFINITION_PARAMETERS && (_jsx(FunctionDefinitionParameterCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.FUNCTION_DEFINITION_ROOT && (_jsx(FunctionDefinitionRootCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.INVOCATION_FUNCTION_CALL && (_jsx(InvocationFunctionCallCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.INVOCATION_INFORMATION_ITEM_CELL && (_jsx(InvocationInformationItemCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.ITERATOR_VARIABLE_CELL && (_jsx(IteratorVariableCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.LITERAL_EXPRESSION_CONTENT && (_jsx(LiteralExpressionContentCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly })), (boxedExpressionPropertiesPanelComponent === null || boxedExpressionPropertiesPanelComponent === void 0 ? void 0 : boxedExpressionPropertiesPanelComponent.component) ===
                                    BoxedExpressionPropertiesPanelComponent.RELATION_INFORMATION_ITEM_CELL && (_jsx(RelationInformationItemCell, { boxedExpressionIndex: boxedExpressionIndex, isReadonly: isReadonly }))] })) }))] }) }))) }));
}
//# sourceMappingURL=BoxedExpressionPropertiesPanel.js.map