export function addMissingImportNamespaces(definitions) {
    if (definitions.import === undefined) {
        return;
    }
    var definedNamespaces = new Set(Object.keys(definitions)
        .filter(function (keys) { return String(keys).startsWith("@_xmlns:"); })
        .map(function (xmlnsKey) { return definitions[xmlnsKey]; }));
    var includedIndex = 0;
    for (var index = 0; index < definitions.import.length; index++) {
        var importedModelNamespace = definitions.import[index]["@_namespace"];
        if (definedNamespaces.has(importedModelNamespace)) {
            continue;
        }
        while (definitions["@_xmlns:included".concat(includedIndex)]) {
            includedIndex++;
        }
        definitions["@_xmlns:included".concat(includedIndex)] = importedModelNamespace;
    }
}
//# sourceMappingURL=addMissingImportNamespaces.js.map