var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export class ProcessListGatewayApiImpl {
    constructor(queries) {
        this.listeners = [];
        this.openProcess = (process) => {
            this.listeners.forEach((listener) => listener.onOpen(process));
            return Promise.resolve();
        };
        this.initialLoad = (filter, sortBy) => {
            this._ProcessListState.filters = filter;
            this._ProcessListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.applyFilter = (filter) => {
            this.processListState.filters = filter;
            return Promise.resolve();
        };
        this.applySorting = (sortBy) => {
            this._ProcessListState.sortBy = sortBy;
            return Promise.resolve();
        };
        this.handleProcessSkip = (processInstance) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleProcessSkip(processInstance);
        });
        this.handleProcessRetry = (processInstance) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleProcessRetry(processInstance);
        });
        this.handleProcessAbort = (processInstance) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleProcessAbort(processInstance);
        });
        this.handleProcessMultipleAction = (processInstances, operationType) => __awaiter(this, void 0, void 0, function* () {
            return this.queries.handleProcessMultipleAction(processInstances, operationType);
        });
        this.queries = queries;
        this._ProcessListState = {
            filters: {
                status: [],
                businessKey: [],
            },
            sortBy: {},
        };
    }
    get processListState() {
        return this._ProcessListState;
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getProcessInstances(offset, limit, this._ProcessListState.filters, this._ProcessListState.sortBy)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    getChildProcessesQuery(rootProcessInstanceId) {
        return new Promise((resolve, reject) => {
            this.queries
                .getChildProcessInstances(rootProcessInstanceId)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    onOpenProcessListen(listener) {
        this.listeners.push(listener);
        const unSubscribe = () => {
            const index = this.listeners.indexOf(listener);
            if (index > -1) {
                this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    openTriggerCloudEvent(processInstance) {
        console.info("not supported");
    }
}
//# sourceMappingURL=ProcessListGatewayApi.js.map