import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import CogIcon from "@patternfly/react-icons/dist/esm/icons/cog-icon";
import EditIcon from "@patternfly/react-icons/dist/esm/icons/edit-alt-icon";
import InfoIcon from "@patternfly/react-icons/dist/esm/icons/info-icon";
import { TestScenarioEditorDock } from "../TestScenarioEditor";
import { useTestScenarioEditorI18n } from "../i18n";
import "./TestScenarioSideBarMenu.css";
function TestScenarioSideBarMenu({ onSideBarButtonClicked, selectedSideBarMenuItem, }) {
    const { i18n } = useTestScenarioEditorI18n();
    const isSelectedMenuItem = useCallback((item) => {
        return selectedSideBarMenuItem.isOpen && selectedSideBarMenuItem.selected === item;
    }, [selectedSideBarMenuItem]);
    return (_jsxs("div", Object.assign({ className: "kie-scesim-editor--side-bar" }, { children: [_jsx(Tooltip, Object.assign({ content: i18n.sidebar.dataSelectorTooltip }, { children: _jsx(Button, { className: isSelectedMenuItem(TestScenarioEditorDock.DATA_OBJECT)
                        ? "kie-scesim-editor-side-bar-menu--button-selected"
                        : "kie-scesim-editor-side-bar-menu--button", variant: "plain", onClick: () => onSideBarButtonClicked(TestScenarioEditorDock.DATA_OBJECT), icon: _jsx(EditIcon, {}) }) })), _jsx(Tooltip, Object.assign({ content: i18n.sidebar.cheatSheetTooltip }, { children: _jsx(Button, { className: isSelectedMenuItem(TestScenarioEditorDock.CHEATSHEET)
                        ? "kie-scesim-editor-side-bar-menu--button-selected"
                        : "kie-scesim-editor-side-bar-menu--button", icon: _jsx(InfoIcon, {}), onClick: () => onSideBarButtonClicked(TestScenarioEditorDock.CHEATSHEET), variant: "plain" }) })), _jsx(Tooltip, Object.assign({ content: _jsx("div", { children: i18n.sidebar.settingsTooltip }) }, { children: _jsx(Button, { className: isSelectedMenuItem(TestScenarioEditorDock.SETTINGS)
                        ? "kie-scesim-editor-side-bar-menu--button-selected"
                        : "kie-scesim-editor-side-bar-menu--button", icon: _jsx(CogIcon, {}), onClick: () => onSideBarButtonClicked(TestScenarioEditorDock.SETTINGS), variant: "plain" }) }))] })));
}
export default TestScenarioSideBarMenu;
//# sourceMappingURL=TestScenarioSideBarMenu.js.map