/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.apache.bifromq.basecrdt.core.internal.DotStore;
import org.apache.bifromq.basecrdt.core.internal.IDotSet;
import org.apache.bifromq.basecrdt.core.internal.ProtoUtils;
import org.apache.bifromq.basecrdt.proto.Dot;
import org.apache.bifromq.basecrdt.proto.StateLattice;

class DotSet
extends DotStore
implements IDotSet {
    public static final IDotSet BOTTOM = new DotSet();
    private final Set<Dot> dots = Sets.newConcurrentHashSet();

    DotSet() {
    }

    @Override
    public Iterator<Dot> iterator() {
        return this.dots.iterator();
    }

    @Override
    public boolean isBottom() {
        return this.dots.isEmpty();
    }

    @Override
    boolean add(StateLattice addState) {
        assert (addState.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEDOT);
        return this.dots.add(ProtoUtils.dot(addState.getSingleDot().getReplicaId(), addState.getSingleDot().getVer()));
    }

    @Override
    boolean remove(StateLattice removeState) {
        assert (removeState.getStateTypeCase() == StateLattice.StateTypeCase.SINGLEDOT);
        return this.dots.remove(ProtoUtils.dot(removeState.getSingleDot().getReplicaId(), removeState.getSingleDot().getVer()));
    }

    public String toString() {
        return "DotSet{dots=" + String.valueOf(this.dots) + "}";
    }
}

