/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.server;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisFlushCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.FLUSHDB, GridRedisCommand.FLUSHALL);

    public GridRedisFlushCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        super(log, hnd, ctx);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        GridRestCacheRequest restReq = new GridRestCacheRequest();
        restReq.clientId(msg.clientId());
        switch (msg.command()) {
            case FLUSHDB: {
                restReq.command(GridRestCommand.CACHE_REMOVE_ALL);
                restReq.cacheName(msg.cacheName());
                break;
            }
            default: {
                HashMap<Object, Object> redisCaches = new HashMap<Object, Object>();
                for (IgniteCacheProxy<?, ?> cache : this.ctx.cache().publicCaches()) {
                    if (!cache.getName().startsWith("redis-ignite-internal-cache")) continue;
                    redisCaches.put(cache.getName(), null);
                }
                if (redisCaches.isEmpty()) {
                    throw new GridRedisGenericException("No Redis caches found");
                }
                restReq.command(GridRestCommand.CACHE_CLEAR);
                restReq.values(redisCaches);
            }
        }
        return restReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        return (Boolean)restRes.getResponse() != false ? GridRedisProtocolParser.oKString() : GridRedisProtocolParser.toGenericError("Failed to flush");
    }
}

