/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.IgniteUtils;

public class Cleaner<T> {
    private static final IgniteLogger LOG = Loggers.forClass(Cleaner.class);
    private ExecutorService cleaner;
    private final Set<UUID> toRemove = new HashSet<UUID>();
    private final Queue<UUID> waitToRemove = new ConcurrentLinkedQueue<UUID>();

    public void start(Consumer<UUID> clean, long ttlMillis, String nodeName) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create(nodeName, "compute-execution-cleanup", true, LOG, new ThreadOperation[0]));
        executor.scheduleAtFixedRate(() -> {
            UUID nextToRemove;
            this.toRemove.forEach(clean);
            this.toRemove.clear();
            while ((nextToRemove = this.waitToRemove.poll()) != null) {
                this.toRemove.add(nextToRemove);
            }
        }, ttlMillis, ttlMillis, TimeUnit.MILLISECONDS);
        this.cleaner = executor;
    }

    public void stop() {
        IgniteUtils.shutdownAndAwaitTermination(this.cleaner, 1000L, TimeUnit.MILLISECONDS);
    }

    public void scheduleRemove(UUID entryId) {
        this.waitToRemove.add(entryId);
    }
}

