/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.rules.ImmutableSetOpToFilterRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Enclosing
public class SetOpToFilterRule
extends RelRule<Config>
implements TransformationRule {
    protected SetOpToFilterRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void match(RelOptRuleCall call) {
        SetOp setOp = (SetOp)call.rel(0);
        List<RelNode> inputs = setOp.getInputs();
        if (setOp.all || inputs.size() < 2) {
            return;
        }
        RelBuilder builder = call.builder();
        Pair<RelNode, @Nullable RexNode> first = SetOpToFilterRule.extractSourceAndCond(inputs.get(0).stripped());
        LinkedHashMap<@Nullable Pair, @Nullable List> sourceToConds = new LinkedHashMap<Pair, List>();
        RelNode firstSource = (RelNode)first.left;
        sourceToConds.computeIfAbsent(Pair.of(firstSource, null), k -> new ArrayList()).add(first.right);
        for (int i = 1; i < inputs.size(); ++i) {
            RelNode input = inputs.get(i).stripped();
            Pair<RelNode, @Nullable RexNode> pair = SetOpToFilterRule.extractSourceAndCond(input);
            sourceToConds.computeIfAbsent(Pair.of(pair.left, pair.right != null ? null : Integer.valueOf(i)), k -> new ArrayList()).add(pair.right);
        }
        if (sourceToConds.size() == inputs.size()) {
            return;
        }
        int branchCount = 0;
        for (Map.Entry entry : sourceToConds.entrySet()) {
            @Nullable Pair left = (Pair)entry.getKey();
            @Nullable List conds = (List)entry.getValue();
            if (conds.size() == 1 && conds.get(0) == null) {
                builder.push((RelNode)left.left);
                ++branchCount;
                continue;
            }
            List<RexNode> condsNonNull = conds.stream().map(e -> {
                assert (e != null);
                return e;
            }).collect(Collectors.toList());
            RexNode combinedCond = this.combineConditions(builder, condsNonNull, setOp, left.left == firstSource);
            builder.push((RelNode)left.left).filter(combinedCond);
            ++branchCount;
        }
        SetOpToFilterRule.buildSetOp(builder, branchCount, setOp).distinct();
        call.transformTo(builder.build());
    }

    private static RelBuilder buildSetOp(RelBuilder builder, int count, RelNode setOp) {
        if (setOp instanceof Union) {
            return builder.union(false, count);
        }
        if (setOp instanceof Intersect) {
            return builder.intersect(false, count);
        }
        if (setOp instanceof Minus) {
            return builder.minus(false, count);
        }
        throw new IllegalStateException("unreachable code");
    }

    private static Pair<RelNode, @Nullable RexNode> extractSourceAndCond(RelNode input) {
        if (input instanceof Filter) {
            Filter filter = (Filter)input;
            if (!RexUtil.isDeterministic(filter.getCondition()) || RexUtil.SubQueryFinder.containsSubQuery(filter)) {
                return Pair.of(input, null);
            }
            return Pair.of(filter.getInput().stripped(), filter.getCondition());
        }
        return Pair.of(input.stripped(), input.getCluster().getRexBuilder().makeLiteral(true));
    }

    private static RexNode andFirstNotRest(RelBuilder builder, List<RexNode> conds) {
        ArrayList<RexNode> allConds = new ArrayList<RexNode>();
        allConds.add(conds.get(0));
        for (int i = 1; i < conds.size(); ++i) {
            allConds.add(builder.not(conds.get(i)));
        }
        return builder.and(allConds);
    }

    private RexNode combineConditions(RelBuilder builder, List<RexNode> conds, SetOp setOp, boolean isFirstSource) {
        if (setOp instanceof Union) {
            return builder.or(conds);
        }
        if (setOp instanceof Intersect) {
            return builder.and(conds);
        }
        if (setOp instanceof Minus) {
            return isFirstSource ? SetOpToFilterRule.andFirstNotRest(builder, conds) : builder.or(conds);
        }
        throw new IllegalStateException("unreachable code");
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config UNION = ImmutableSetOpToFilterRule.Config.builder().withMatchHandler((rec$, x$0) -> SetOpToFilterRule.access$000((SetOpToFilterRule)rec$, x$0)).build().withOperandSupplier(b0 -> b0.operand(Union.class).anyInputs()).as(Config.class);
        public static final Config INTERSECT = ImmutableSetOpToFilterRule.Config.builder().withMatchHandler((rec$, x$0) -> SetOpToFilterRule.access$000((SetOpToFilterRule)rec$, x$0)).build().withOperandSupplier(b0 -> b0.operand(Intersect.class).anyInputs()).as(Config.class);
        public static final Config MINUS = ImmutableSetOpToFilterRule.Config.builder().withMatchHandler((rec$, x$0) -> SetOpToFilterRule.access$000((SetOpToFilterRule)rec$, x$0)).build().withOperandSupplier(b0 -> b0.operand(Minus.class).anyInputs()).as(Config.class);

        @Override
        default public SetOpToFilterRule toRule() {
            return new SetOpToFilterRule(this);
        }

        public RelRule.MatchHandler<SetOpToFilterRule> matchHandler();

        public Config withMatchHandler(RelRule.MatchHandler<SetOpToFilterRule> var1);
    }
}

