/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashJoin;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;

public class HashJoinConverterRule
extends AbstractIgniteConverterRule<LogicalJoin> {
    private static final EnumSet<JoinRelType> TYPES_SUPPORTING_NON_EQUI_CONDITIONS = EnumSet.of(JoinRelType.INNER, JoinRelType.SEMI, JoinRelType.LEFT);
    public static final RelOptRule INSTANCE = new HashJoinConverterRule();

    private HashJoinConverterRule() {
        super(LogicalJoin.class, "HashJoinConverter");
    }

    public boolean matches(RelOptRuleCall call) {
        LogicalJoin logicalJoin = (LogicalJoin)call.rel(0);
        return HashJoinConverterRule.matches(logicalJoin);
    }

    public static boolean matches(LogicalJoin join) {
        JoinInfo joinInfo = Commons.getNonStrictEquiJoinCondition(join);
        if (CollectionUtils.nullOrEmpty((Collection)joinInfo.pairs())) {
            return false;
        }
        ArrayList filterNulls = new ArrayList();
        RelOptUtil.splitJoinCondition((RelNode)join.getLeft(), (RelNode)join.getRight(), (RexNode)join.getCondition(), new ArrayList(), new ArrayList(), filterNulls);
        if (filterNulls.stream().anyMatch(filter -> filter == false)) {
            return false;
        }
        return joinInfo.isEqui() || TYPES_SUPPORTING_NON_EQUI_CONDITIONS.contains(join.getJoinType());
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalJoin rel) {
        RelOptCluster cluster = rel.getCluster();
        RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
        RelNode left = HashJoinConverterRule.convert((RelNode)rel.getLeft(), (RelTraitSet)traits);
        RelNode right = HashJoinConverterRule.convert((RelNode)rel.getRight(), (RelTraitSet)traits);
        return new IgniteHashJoin(cluster, traits, left, right, rel.getCondition(), rel.getVariablesSet(), rel.getJoinType());
    }
}

