/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ExecutionContext;
import org.apache.ignite.internal.compute.FailSafeJobExecution;
import org.apache.ignite.internal.compute.NextWorkerSelector;
import org.apache.ignite.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite.internal.compute.events.ComputeEventsFactory;
import org.apache.ignite.internal.eventlog.api.EventLog;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.lang.ErrorGroups;

class ComputeJobFailover {
    private static final IgniteLogger LOG = Loggers.forClass(ComputeJobFailover.class);
    private final ComputeComponent computeComponent;
    private final LogicalTopologyService logicalTopologyService;
    private final TopologyService topologyService;
    private final Executor executor;
    private final EventLog eventLog;
    private final AtomicReference<InternalClusterNode> runningWorkerNode;
    private final NextWorkerSelector nextWorkerSelector;
    private final ExecutionContext jobContext;
    private final UUID jobId = UUID.randomUUID();
    private FailSafeJobExecution failSafeExecution;

    private ComputeJobFailover(ComputeComponent computeComponent, LogicalTopologyService logicalTopologyService, TopologyService topologyService, Executor executor, EventLog eventLog, InternalClusterNode workerNode, NextWorkerSelector nextWorkerSelector, ExecutionContext executionContext) {
        this.computeComponent = computeComponent;
        this.logicalTopologyService = logicalTopologyService;
        this.topologyService = topologyService;
        this.executor = executor;
        this.eventLog = eventLog;
        this.runningWorkerNode = new AtomicReference<InternalClusterNode>(workerNode);
        this.nextWorkerSelector = nextWorkerSelector;
        executionContext.metadataBuilder().jobId(this.jobId);
        this.jobContext = executionContext;
    }

    static CompletableFuture<CancellableJobExecution<ComputeJobDataHolder>> failSafeExecute(ComputeComponent computeComponent, LogicalTopologyService logicalTopologyService, TopologyService topologyService, Executor executor, EventLog eventLog, InternalClusterNode workerNode, NextWorkerSelector nextWorkerSelector, ExecutionContext executionContext) {
        return new ComputeJobFailover(computeComponent, logicalTopologyService, topologyService, executor, eventLog, workerNode, nextWorkerSelector, executionContext).execute();
    }

    private CompletableFuture<CancellableJobExecution<ComputeJobDataHolder>> execute() {
        return this.launchJobOn(this.runningWorkerNode.get()).thenApply(execution -> {
            this.failSafeExecution = new FailSafeJobExecution((CancellableJobExecution<ComputeJobDataHolder>)execution, this.jobId);
            OnNodeLeft nodeLeftEventListener = new OnNodeLeft();
            this.logicalTopologyService.addEventListener((LogicalTopologyEventListener)nodeLeftEventListener);
            this.failSafeExecution.resultAsync().whenComplete((r, e) -> this.logicalTopologyService.removeEventListener(nodeLeftEventListener));
            return this.failSafeExecution;
        });
    }

    private CompletableFuture<CancellableJobExecution<ComputeJobDataHolder>> launchJobOn(InternalClusterNode runningWorkerNode) {
        if (runningWorkerNode.name().equals(this.topologyService.localMember().name())) {
            return this.computeComponent.executeLocally(this.jobContext, null);
        }
        return this.computeComponent.executeRemotely(runningWorkerNode, this.jobContext, null);
    }

    private class OnNodeLeft
    implements LogicalTopologyEventListener {
        private OnNodeLeft() {
        }

        public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
            if (!ComputeJobFailover.this.runningWorkerNode.get().id().equals(leftNode.id())) {
                return;
            }
            LOG.info("Worker node {} has left the cluster.", new Object[]{leftNode.name()});
            ComputeJobFailover.this.executor.execute(this::selectNewWorker);
        }

        private void selectNewWorker() {
            ComputeJobFailover.this.nextWorkerSelector.next().thenAccept(nextWorker -> {
                if (nextWorker == null) {
                    LOG.warn("No more worker nodes to restart the job. Failing the job {}.", new Object[]{ComputeJobFailover.this.jobContext.jobClassName()});
                    this.logJobFailedEvent();
                    ComputeJobFailover.this.failSafeExecution.completeExceptionally((Exception)new IgniteInternalException(ErrorGroups.Compute.COMPUTE_JOB_FAILED_ERR));
                    return;
                }
                if (ComputeJobFailover.this.topologyService.getByConsistentId(nextWorker.name()) == null) {
                    LOG.warn("Worker node {} is not found in the cluster", new Object[]{nextWorker.name()});
                    ComputeJobFailover.this.executor.execute(this::selectNewWorker);
                    return;
                }
                LOG.info("Restarting the job {} on node {}.", new Object[]{ComputeJobFailover.this.jobContext.jobClassName(), nextWorker.name()});
                ComputeJobFailover.this.runningWorkerNode.set((InternalClusterNode)nextWorker);
                ComputeJobFailover.this.launchJobOn((InternalClusterNode)nextWorker).thenAccept(execution -> ComputeJobFailover.this.failSafeExecution.updateJobExecution((CancellableJobExecution<ComputeJobDataHolder>)execution));
            });
        }

        private void logJobFailedEvent() {
            ComputeEventMetadata eventMetadata = ComputeJobFailover.this.jobContext.metadataBuilder().jobClassName(ComputeJobFailover.this.jobContext.jobClassName()).targetNode(ComputeJobFailover.this.runningWorkerNode.get().name()).build();
            ComputeEventsFactory.logJobFailedEvent(ComputeJobFailover.this.eventLog, eventMetadata);
        }
    }
}

