/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.AlterColumnEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class AlterColumnEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<AlterColumnEntry> SERIALIZER = new AlterColumnEntrySerializer();
    private final int tableId;
    private final CatalogTableColumnDescriptor column;

    public AlterColumnEntry(int tableId, CatalogTableColumnDescriptor column) {
        this.tableId = tableId;
        this.column = column;
    }

    public int tableId() {
        return this.tableId;
    }

    public CatalogTableColumnDescriptor descriptor() {
        return this.column;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ALTER_COLUMN.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new AlterColumnEventParameters(causalityToken, catalogVersion, this.tableId, this.column);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.tableId);
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        CatalogTableDescriptor newTable = table.newDescriptor(table.name(), table.tableVersion() + 1, table.columns().stream().map(source -> source.name().equals(this.column.name()) ? this.column : source).collect(Collectors.toList()), causalityToken, table.storageProfile());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(CatalogUtils.replaceTable(schema, newTable), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class AlterColumnEntrySerializer
    implements CatalogObjectSerializer<AlterColumnEntry> {
        private AlterColumnEntrySerializer() {
        }

        @Override
        public AlterColumnEntry readFrom(IgniteDataInput input) throws IOException {
            CatalogTableColumnDescriptor descriptor = CatalogTableColumnDescriptor.SERIALIZER.readFrom(input);
            int tableId = input.readVarIntAsInt();
            return new AlterColumnEntry(tableId, descriptor);
        }

        @Override
        public void writeTo(AlterColumnEntry value, IgniteDataOutput output) throws IOException {
            CatalogTableColumnDescriptor.SERIALIZER.writeTo(value.descriptor(), output);
            output.writeVarInt((long)value.tableId);
        }
    }
}

