/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.views;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Flow;
import org.apache.ignite.internal.systemview.api.NodeSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.apache.ignite.internal.util.TransformingIterator;
import org.jetbrains.annotations.Nullable;

public class TransactionsViewProvider {
    public static final String READ_ONLY = "READ_ONLY";
    public static final String READ_WRITE = "READ_WRITE";
    private volatile Iterable<TxInfo> dataSource;

    public void init(UUID localNodeId, Collection<UUID> roTxIds, Map<UUID, TxStateMeta> rwTxStates) {
        this.dataSource = new TxInfoDataSource(localNodeId, roTxIds, rwTxStates);
    }

    public SystemView<?> get() {
        Flow.Publisher dataProvider = SubscriptionUtils.fromIterable(() -> {
            Iterable<TxInfo> dataSource0 = this.dataSource;
            return dataSource0 == null ? Collections.emptyIterator() : dataSource0.iterator();
        });
        NativeType stringType = NativeTypes.stringOf((int)64);
        NativeType timestampType = NativeTypes.timestamp((int)9);
        return ((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)SystemViews.nodeViewBuilder().name("TRANSACTIONS")).nodeNameColumnAlias("COORDINATOR_NODE_ID").addColumn("STATE", stringType, tx -> tx.state)).addColumn("ID", stringType, tx -> tx.id)).addColumn("START_TIME", timestampType, tx -> tx.startTime)).addColumn("TYPE", stringType, tx -> tx.type)).addColumn("PRIORITY", stringType, tx -> tx.priority)).dataProvider(dataProvider)).build();
    }

    static class TxInfoDataSource
    implements Iterable<TxInfo> {
        private final UUID localNodeId;
        private final Iterable<UUID> roTxIds;
        private final Map<UUID, TxStateMeta> rwTxStates;

        TxInfoDataSource(UUID localNodeId, Iterable<UUID> roTxIds, Map<UUID, TxStateMeta> rwTxStates) {
            this.localNodeId = localNodeId;
            this.roTxIds = roTxIds;
            this.rwTxStates = rwTxStates;
        }

        @Override
        public Iterator<TxInfo> iterator() {
            return CollectionUtils.concat((Iterator[])new Iterator[]{new TransformingIterator(this.roTxIds.iterator(), TxInfo::readOnly), this.rwTxStates.entrySet().stream().filter(e -> this.localNodeId.equals(((TxStateMeta)e.getValue()).txCoordinatorId()) && !TxState.isFinalState(((TxStateMeta)e.getValue()).txState())).map(e -> TxInfo.readWrite((UUID)e.getKey(), ((TxStateMeta)e.getValue()).txState())).iterator()});
        }
    }

    static class TxInfo {
        private final String id;
        @Nullable
        private final String state;
        private final Instant startTime;
        private final String type;
        private final String priority;

        static TxInfo readOnly(UUID id) {
            return new TxInfo(id, null, true);
        }

        static TxInfo readWrite(UUID id, TxState txState) {
            return new TxInfo(id, txState, false);
        }

        private TxInfo(UUID id, @Nullable TxState state, boolean readOnly) {
            this.id = id.toString();
            this.state = state == null ? null : state.name();
            this.startTime = Instant.ofEpochMilli(TransactionIds.beginTimestamp(id).getPhysical());
            this.type = readOnly ? TransactionsViewProvider.READ_ONLY : TransactionsViewProvider.READ_WRITE;
            this.priority = TransactionIds.priority(id).name();
        }
    }
}

