/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import org.apache.ignite.internal.tx.TxPriority;

public class InternalTxOptions {
    private static final InternalTxOptions DEFAULT_OPTIONS = InternalTxOptions.builder().build();
    private final TxPriority priority;
    private final long timeoutMillis;

    private InternalTxOptions(TxPriority priority, long timeoutMillis) {
        this.priority = priority;
        this.timeoutMillis = timeoutMillis;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InternalTxOptions defaults() {
        return DEFAULT_OPTIONS;
    }

    public static InternalTxOptions defaultsWithPriority(TxPriority priority) {
        return InternalTxOptions.builder().priority(priority).build();
    }

    public TxPriority priority() {
        return this.priority;
    }

    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    public static class Builder {
        private TxPriority priority = TxPriority.NORMAL;
        private long timeoutMillis = 0L;

        public Builder priority(TxPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public InternalTxOptions build() {
            return new InternalTxOptions(this.priority, this.timeoutMillis);
        }
    }
}

