/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.TestOnly;

public class VersatileReadWriteLock {
    private static final int WRITE_LOCK_BITS = Integer.MIN_VALUE;
    private static final int READ_LOCK_BITS = Integer.MAX_VALUE;
    private static final int AVAILABLE = 0;
    private static final int SLEEP_MILLIS = 10;
    private static final VarHandle PENDING_WLOCKS_VH;
    private static final VarHandle STATE_VH;
    private volatile int state;
    private volatile int pendingWriteLocks;
    private final Set<CompletableFuture<Void>> readLockWaitSet = ConcurrentHashMap.newKeySet();
    private final Set<CompletableFuture<Void>> writeLockWaitSet = ConcurrentHashMap.newKeySet();
    private final Executor asyncContinuationExecutor;

    public VersatileReadWriteLock(Executor asyncContinuationExecutor) {
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    public void readLock() {
        block4: {
            boolean interrupted = false;
            while (true) {
                int curState;
                if (this.writeLockedOrGoingToBe(curState = this.state)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                    }
                    continue;
                }
                if (this.tryAdvanceStateToReadLocked(curState)) break;
            }
            if (!interrupted) break block4;
            Thread.currentThread().interrupt();
        }
    }

    private static int state(boolean writeLocked, int readLocks) {
        assert (readLocks >= 0) : readLocks;
        return (writeLocked ? Integer.MIN_VALUE : 0) | readLocks & Integer.MAX_VALUE;
    }

    private static boolean writeLocked(int curState) {
        return (curState & Integer.MIN_VALUE) != 0;
    }

    private static int readLocks(int state) {
        return state & Integer.MAX_VALUE;
    }

    private boolean writeLockedOrGoingToBe(int curState) {
        return VersatileReadWriteLock.writeLocked(curState) || this.pendingWriteLocks > 0;
    }

    private boolean tryAdvanceStateToReadLocked(int curState) {
        assert (!VersatileReadWriteLock.writeLocked(curState));
        int newState = VersatileReadWriteLock.state(false, VersatileReadWriteLock.readLocks(curState) + 1);
        return STATE_VH.compareAndSet(this, curState, newState);
    }

    public boolean tryReadLock() {
        int curState;
        do {
            if (!this.writeLockedOrGoingToBe(curState = this.state)) continue;
            return false;
        } while (!this.tryAdvanceStateToReadLocked(curState));
        return true;
    }

    public void readUnlock() {
        int readLocks;
        boolean writeLocked;
        int curState;
        do {
            curState = this.state;
            writeLocked = VersatileReadWriteLock.writeLocked(curState);
            readLocks = VersatileReadWriteLock.readLocks(curState);
            if (readLocks >= 1) continue;
            throw new IllegalMonitorStateException();
        } while (!STATE_VH.compareAndSet(this, curState, VersatileReadWriteLock.state(writeLocked, readLocks - 1)));
        if (readLocks == 1) {
            this.notifyWriteLockWaitSet();
        }
    }

    public void writeLock() {
        boolean interrupted = false;
        this.incrementPendingWriteLocks();
        try {
            while (!this.trySwitchStateToWriteLocked()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
        }
        finally {
            this.decrementPendingWriteLocks();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void incrementPendingWriteLocks() {
        int curPendingWriteLocks;
        while (!PENDING_WLOCKS_VH.compareAndSet(this, curPendingWriteLocks = this.pendingWriteLocks, curPendingWriteLocks + 1)) {
        }
    }

    private boolean trySwitchStateToWriteLocked() {
        return STATE_VH.compareAndSet(this, 0, VersatileReadWriteLock.state(true, 0));
    }

    private void decrementPendingWriteLocks() {
        int curPendingWriteLocks;
        do {
            curPendingWriteLocks = this.pendingWriteLocks;
            assert (curPendingWriteLocks > 0);
        } while (!PENDING_WLOCKS_VH.compareAndSet(this, curPendingWriteLocks, curPendingWriteLocks - 1));
    }

    public void writeLockBusy() {
        this.incrementPendingWriteLocks();
        try {
            while (!this.trySwitchStateToWriteLocked()) {
            }
        }
        finally {
            this.decrementPendingWriteLocks();
        }
    }

    public boolean tryWriteLock() {
        return this.trySwitchStateToWriteLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteLock(long timeout, TimeUnit unit) throws InterruptedException {
        this.incrementPendingWriteLocks();
        try {
            long startNanos = System.nanoTime();
            long timeoutNanos = unit.toNanos(timeout);
            do {
                if (this.trySwitchStateToWriteLocked()) {
                    boolean bl = true;
                    return bl;
                }
                Thread.sleep(10L);
            } while (System.nanoTime() - startNanos < timeoutNanos);
            boolean bl = false;
            return bl;
        }
        finally {
            this.decrementPendingWriteLocks();
        }
    }

    public void writeUnlock() {
        int readLocks;
        int curState;
        do {
            if (VersatileReadWriteLock.writeLocked(curState = this.state)) continue;
            throw new IllegalMonitorStateException();
        } while (!STATE_VH.compareAndSet(this, curState, VersatileReadWriteLock.state(false, readLocks = VersatileReadWriteLock.readLocks(curState))));
        this.notifyWriteLockWaitSet();
        this.notifyReadLockWaitSet();
    }

    private void notifyWriteLockWaitSet() {
        if (this.writeLockWaitSet.isEmpty()) {
            return;
        }
        Iterator<CompletableFuture<Void>> iterator = this.writeLockWaitSet.iterator();
        while (iterator.hasNext() && this.tryWriteLock()) {
            CompletableFuture<Void> future = iterator.next();
            iterator.remove();
            if (!future.isDone()) {
                this.decrementPendingWriteLocks();
                this.asyncContinuationExecutor.execute(() -> future.complete(null));
                continue;
            }
            this.writeUnlock();
        }
    }

    private void notifyReadLockWaitSet() {
        if (this.readLockWaitSet.isEmpty()) {
            return;
        }
        Iterator<CompletableFuture<Void>> iterator = this.readLockWaitSet.iterator();
        while (iterator.hasNext() && this.tryReadLock()) {
            CompletableFuture<Void> future = iterator.next();
            iterator.remove();
            this.asyncContinuationExecutor.execute(() -> {
                if (!future.complete(null)) {
                    this.readUnlock();
                }
            });
        }
    }

    public <T> CompletableFuture<T> inReadLockAsync(Supplier<? extends CompletableFuture<T>> action) {
        return ((CompletableFuture)this.readLockAsync().thenCompose(unused -> (CompletionStage)action.get())).whenComplete((res, ex) -> this.readUnlock());
    }

    private CompletableFuture<Void> readLockAsync() {
        if (this.tryReadLock()) {
            return CompletableFutures.nullCompletedFuture();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.readLockWaitSet.add(future);
        if (this.tryReadLock()) {
            this.readLockWaitSet.remove(future);
            if (!future.complete(null)) {
                this.readUnlock();
            }
        }
        return future;
    }

    public <T> CompletableFuture<T> inWriteLockAsync(Supplier<? extends CompletableFuture<T>> action) {
        return ((CompletableFuture)this.writeLockAsync().thenCompose(unused -> (CompletionStage)action.get())).whenComplete((res, ex) -> this.writeUnlock());
    }

    private CompletableFuture<Void> writeLockAsync() {
        if (this.tryWriteLock()) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.incrementPendingWriteLocks();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.writeLockWaitSet.add(future);
        if (this.tryWriteLock()) {
            this.writeLockWaitSet.remove(future);
            if (!future.isDone()) {
                this.decrementPendingWriteLocks();
                future.complete(null);
            } else {
                this.writeUnlock();
            }
        }
        return future;
    }

    @TestOnly
    int pendingWriteLocksCount() {
        return this.pendingWriteLocks;
    }

    boolean isWriteLocked() {
        return VersatileReadWriteLock.writeLocked(this.state);
    }

    int readLocksHeld() {
        return VersatileReadWriteLock.readLocks(this.state);
    }

    public String toString() {
        return S.toString(VersatileReadWriteLock.class, this);
    }

    static {
        try {
            STATE_VH = MethodHandles.lookup().findVarHandle(VersatileReadWriteLock.class, "state", Integer.TYPE);
            PENDING_WLOCKS_VH = MethodHandles.lookup().findVarHandle(VersatileReadWriteLock.class, "pendingWriteLocks", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

