/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.pagememory.util.GradualTask;

public class GradualTaskExecutor
implements ManuallyCloseable {
    private final ExecutorService executor;
    private final InFlightFutures inFlightFutures = new InFlightFutures();
    private volatile boolean cancelled = false;

    public GradualTaskExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public CompletableFuture<Void> execute(final GradualTask task) {
        final CompletableFuture future = new CompletableFuture();
        this.inFlightFutures.registerFuture(future);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (task.isCompleted()) {
                        future.complete(null);
                        return;
                    }
                    if (GradualTaskExecutor.this.cancelled) {
                        future.completeExceptionally(GradualTaskExecutor.cancellationException());
                        return;
                    }
                    GradualTaskExecutor.this.runStep(task);
                    if (task.isCompleted()) {
                        future.complete(null);
                    } else if (GradualTaskExecutor.this.cancelled) {
                        future.completeExceptionally(GradualTaskExecutor.cancellationException());
                    } else {
                        GradualTaskExecutor.this.executor.execute(this);
                    }
                }
                catch (Error e) {
                    future.completeExceptionally(e);
                    throw e;
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }
        };
        this.executor.execute(runnable);
        return future.whenComplete((res, ex) -> task.cleanup());
    }

    protected void runStep(GradualTask task) throws Exception {
        task.runStep();
    }

    public void close() {
        this.cancelled = true;
        this.inFlightFutures.failInFlightFutures((Exception)GradualTaskExecutor.cancellationException());
    }

    private static GradualTaskCancellationException cancellationException() {
        return new GradualTaskCancellationException("The executor has been closed");
    }

    public ExecutorService executorService() {
        return this.executor;
    }

    public static class GradualTaskCancellationException
    extends CancellationException {
        GradualTaskCancellationException(String message) {
            super(message);
        }
    }
}

