/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.ignite.internal.network.ArrayStripedExecutorByChannelTypeId;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.network.CriticalStripedThreadPoolExecutorFactory;
import org.apache.ignite.internal.network.MapStripedExecutorByChannelTypeId;
import org.apache.ignite.internal.thread.StripedExecutor;

interface StripedExecutorByChannelTypeId {
    public StripedExecutor get(short var1);

    public Stream<StripedExecutor> stream();

    public static StripedExecutorByChannelTypeId of(ChannelTypeRegistry channelTypeRegistry, CriticalStripedThreadPoolExecutorFactory factory) {
        ChannelType[] sortedArray = (ChannelType[])channelTypeRegistry.getAll().stream().sorted(Comparator.comparingInt(ChannelType::id)).toArray(ChannelType[]::new);
        if (sortedArray[0].id() == 0 && sortedArray[sortedArray.length - 1].id() == sortedArray.length - 1) {
            return new ArrayStripedExecutorByChannelTypeId(factory, sortedArray);
        }
        return new MapStripedExecutorByChannelTypeId(factory, sortedArray);
    }
}

